
/* -*- c-basic-offset: 4 indent-tabs-mode: nil -*- vi:set ts=8 sts=4 sw=4: */

/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.

    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>

    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.

    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/

#ifndef _RG_ROSEGARDENPARAMETERBOX_H_
#define _RG_ROSEGARDENPARAMETERBOX_H_

#include "RosegardenParameterArea.h"
#include <tqfont.h>
#include <tqframe.h>
#include <tqstring.h>
#include <klocale.h>


class TQWidget;


namespace Rosegarden
{



/**
 * A flat TQFrame, in which a group of parameters can be laid out.
 * Virtual method functions are defined for for requesting a layout
 * style, and returning the single-word to use for labelling the
 * box.
 */

class RosegardenParameterBox : public TQFrame
{
    Q_OBJECT
  TQ_OBJECT
public:
    RosegardenParameterBox(const TQString &shortLabel, // e.g. i18n("Track")
                           const TQString &longLabel,  // e.g. i18n("Track Parameters")
                           TQWidget *parent = 0,
                           const char *name = 0);

    // Ask for a one-word string that can be used to label the widget.
    TQString getShortLabel() const;

    // Ask for the full label (e.g. short-label "Parameters")
    TQString getLongLabel() const;

    // Get the short label of the prior parameter box (to establish an ordering)
    virtual TQString getPreviousBox(RosegardenParameterArea::Arrangement) const;

    virtual void showAdditionalControls(bool) = 0; 

protected:
    void init();

    // List the layout styles that may be requested via a call to setStyle().

    enum LayoutMode {
        LANDSCAPE_MODE,  // Optimize the layout for a tall and narrow parent.
        PORTRAIT_MODE    // Optimize the layout for a short and wide parent.
    };

    void setLayoutMode(LayoutMode mode);

    TQFont m_font;
    TQString m_shortLabel;    // The string that containers can use for labelling and identification
    TQString m_longLabel;    // The full title
    LayoutMode m_mode;  // The current layout mode.
};


}

#endif
