
/* -*- c-basic-offset: 4 indent-tabs-mode: nil -*- vi:set ts=8 sts=4 sw=4: */

/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.

    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>

    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.

    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/

#ifndef _RG_TUPLETDIALOG_H_
#define _RG_TUPLETDIALOG_H_

#include "base/NotationTypes.h"
#include <kdialogbase.h>
#include "base/Event.h"


class TQWidget;
class TQString;
class TQLabel;
class TQGroupBox;
class TQCheckBox;
class KComboBox;


namespace Rosegarden
{



class TupletDialog : public KDialogBase
{
    Q_OBJECT
  TQ_OBJECT

public:
    TupletDialog(TQWidget *parent,
                 Note::Type defaultUnitType,
                 timeT maxDuration = 0);

    Note::Type getUnitType() const;
    int getUntupledCount() const;
    int getTupledCount() const;
    bool hasTimingAlready() const;

public slots:
    void slotUnitChanged(const TQString &);
    void slotUntupledChanged(const TQString &);
    void slotTupledChanged(const TQString &);
    void slotHasTimingChanged();

protected:

    void updateUntupledCombo();
    void updateTupledCombo();
    void updateTimingDisplays();

    //--------------- Data members ---------------------------------

    KComboBox *m_unitCombo;
    KComboBox *m_untupledCombo;
    KComboBox *m_tupledCombo;

    TQCheckBox *m_hasTimingAlready;

    TQGroupBox *m_timingDisplayBox;
    TQLabel *m_selectionDurationDisplay;
    TQLabel *m_untupledDurationCalculationDisplay;
    TQLabel *m_untupledDurationDisplay;
    TQLabel *m_tupledDurationCalculationDisplay;
    TQLabel *m_tupledDurationDisplay;
    TQLabel *m_newGapDurationCalculationDisplay;
    TQLabel *m_newGapDurationDisplay;
    TQLabel *m_unchangedDurationCalculationDisplay;
    TQLabel *m_unchangedDurationDisplay;

    timeT m_maxDuration;
};



}

#endif
