
/* -*- c-basic-offset: 4 indent-tabs-mode: nil -*- vi:set ts=8 sts=4 sw=4: */

/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.

    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>

    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.

    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/

#ifndef _RG_KEYSIGNATUREDIALOG_H_
#define _RG_KEYSIGNATUREDIALOG_H_

#include "base/NotationTypes.h"
#include <string>
#include <kdialogbase.h>
#include <tqstring.h>
#include <tqcheckbox.h>


class TQWidget;
class TQRadioButton;
class TQLabel;
class KComboBox;
class TQCheckBox;


namespace Rosegarden
{

class NotePixmapFactory;


class KeySignatureDialog : public KDialogBase
{
    Q_OBJECT
  TQ_OBJECT

public:
    enum ConversionType {
        NoConversion,
        Convert,
        Transpose
    };

    KeySignatureDialog(TQWidget *parent,
                       NotePixmapFactory *npf,
                       Clef clef,
                       Rosegarden::Key defaultKey =
                       Rosegarden::Key::DefaultKey,
                       bool showApplyToAll = true,
                       bool showConversionOptions = true,
                       TQString explanatoryText = 0);

    bool isValid() const;
    ::Rosegarden::Key getKey() const;

    bool shouldApplyToAll() const;
    bool shouldBeTransposed() const; 
    ConversionType getConversionType() const;
    bool shouldIgnorePercussion() const;

public slots:
    void slotKeyUp();
    void slotKeyDown();
    void slotKeyNameChanged(const TQString &);
    void slotMajorMinorChanged(const TQString &);

protected:

    void redrawKeyPixmap();
    void regenerateKeyCombo();
    void setValid(bool valid);
    std::string getKeyName(const TQString &s, bool minor);

    //--------------- Data members ---------------------------------

    NotePixmapFactory *m_notePixmapFactory;

    Rosegarden::Key m_key;
    Clef m_clef;
    bool m_valid;
    bool m_ignoreComboChanges;

    TQLabel *m_keyLabel;
    KComboBox *m_keyCombo;
    KComboBox *m_majorMinorCombo;
    TQLabel *m_explanatoryLabel;

    TQRadioButton *m_applyToAllButton;
    TQRadioButton *m_yesTransposeButton;

    TQRadioButton *m_noConversionButton;
    TQRadioButton *m_convertButton;
    TQRadioButton *m_transposeButton;

    TQCheckBox *m_noPercussionCheckBox;
};



}

#endif
