/***************************************************************************
 *   Copyright (C) 2006 Nicolas Hadacek <hadacek@kde.org>                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef CLI_INTERACTIVE_H
#define CLI_INTERACTIVE_H

#include <tqfile.h>
#include "common/global/global.h"
#include "common/cli/cli_global.h"
#include "common/global/log.h"
#include "common/common/bitvalue.h"

namespace CLI
{
//----------------------------------------------------------------------------
enum CommandProperty { NoCommandProperty = 0, NeedProgrammer = 1, InputHex = 2,
                       OutputHex = 4, NeedDevice = 8 };
TQ_DECLARE_FLAGS(CommandProperties, CommandProperty)
TQ_DECLARE_OPERATORS_FOR_FLAGS(CommandProperties)

//----------------------------------------------------------------------------
class Interactive : public TQObject, public Log::Base
{
Q_OBJECT
  TQ_OBJECT
public:
  Interactive(TQObject *parent);
  void redisplayPrompt();

private slots:
  void displayPrompt();

private:
  TQFile   _stdin;
  TQString _input;
  void lineRead();
  ExitCode processLine(const TQString &s);
  ExitCode executeRegister(const TQString &name, const TQString &value);
  ExitCode registerList();
  ExitCode variableList();
  ExitCode executeRawCommands(const TQString &filename);
  Address findRegisterAddress(const TQString &name);
  ExitCode start();
  static void signalHandler(int n);
};

} // namespace

#endif
