/***************************************************************************
 *   Copyright (C) 2005 Nicolas Hadacek <hadacek@kde.org>                  *
 *   Copyright (C) 2004 Alain Gibaud <alain.gibaud@free.fr>                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef CONFIG_CENTER_H
#define CONFIG_CENTER_H

#include <tqcheckbox.h>
#include <tqlineedit.h>
#include <tqwidgetstack.h>

#include "common/gui/key_gui.h"
#include "common/gui/dialog.h"
#include "progs/gui/prog_config_widget.h"
#include "global_config.h"
namespace DeviceChooser { class Button; }
class SelectDirectoryWidget;
class ToolsConfigWidget;

//----------------------------------------------------------------------------
BEGIN_DECLARE_CONFIG_WIDGET(BaseGlobalConfig, BaseGlobalConfigWidget)
END_DECLARE_CONFIG_WIDGET

class GlobalConfigWidget : public BaseGlobalConfigWidget
{
Q_OBJECT
  TQ_OBJECT
public:
  GlobalConfigWidget();
  virtual TQString title() const { return i18n("General"); }
  virtual TQString header() const { return i18n("General Configuration"); }
  virtual TQPixmap pixmap() const;
  virtual void loadConfig();

public slots:
  virtual void saveConfig();

private:
  KeyComboBox<Log::DebugLevel> *_showDebug;
};

//----------------------------------------------------------------------------
class StandaloneConfigWidget : public ConfigWidget
{
  Q_OBJECT
  TQ_OBJECT
public:
  StandaloneConfigWidget();
  virtual void loadConfig();
  virtual TQString title() const { return i18n("Standalone File"); }
  virtual TQString header() const { return i18n("Standalone File Compilation"); }
  virtual TQPixmap pixmap() const;

public slots:
  virtual void saveConfig();

private:
  DeviceChooser::Button *_device;
  ToolsConfigWidget     *_tools;
};

//----------------------------------------------------------------------------
class ConfigCenter : public Dialog
{
Q_OBJECT
  TQ_OBJECT
public:
  enum Type { General = 0, ProgSelect, ProgOptions, DebugOptions,
              Standalone, Nb_Types };
  ConfigCenter(Type showType, TQWidget *parent);

public slots:
  virtual void slotOk();
  virtual void slotApply();

private:
  TQWidget      *_pages[Nb_Types];
  ConfigWidget *_configWidgets[Nb_Types];

  static ConfigWidget *factory(Type type);
};

#endif
