/***************************************************************************
 *   Copyright (C) 2006 by Sascha Hlusiak                                  *
 *   Spam84@gmx.de                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/


#ifndef _IMAGEHOLDER_INCLUDED_
#define _IMAGEHOLDER_INCLUDED_


#include <kwinmodule.h>
#include "myrootpixmap.h"

struct WND_CONFIG;

class QImageHolder:public TQObject
{
	Q_OBJECT
  TQ_OBJECT
public:
	QImageHolder(TQImage act,TQImage inact);
	virtual ~QImageHolder();
	
	void Init();
	TQPixmap *image(bool active) { Init(); return active?img_active:img_inactive; }
	void repaint(bool force);

	void setUserdefinedPictures(TQImage act,TQImage inact);

private:
	bool initialized;
	KMyRootPixmap *rootpixmap;
	TQPixmap *img_active,*img_inactive;
	bool userdefinedActive,userdefinedInactive;

	TQPixmap* ApplyEffect(TQImage &src,WND_CONFIG* cfg,TQColorGroup colorgroup);
	
public slots:
	void BackgroundUpdated(const TQImage *);
	void handleDesktopChanged(int desk);
	void CheckSanity();
	
signals:
	void repaintNeeded();
};


#endif
