/***************************************************************************
 *   Copyright (C) 2007 by Todor Gyumyushev   *
 *   yodor@developer.bg   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#include "resizabledragwidget.h"
#include <tqpoint.h>
#include "kmessagebox.h"
#include "tqpainter.h"

ResizableDragWidget::ResizableDragWidget(TQWidget *parent, const char *name, WFlags f)
 : DragWidget(parent,name,f)
{
rsz=false;

}


ResizableDragWidget::~ResizableDragWidget()
{
}

void ResizableDragWidget::mousePressEvent(TQMouseEvent * e)
{
	
	TQPoint pos = e->pos();
	if (pos.x()>width()-20 && pos.x()<width() && pos.y()>height()-20 && pos.y()<height() ) {
		rsz=true;
		dragP=TQPoint(width()-e->pos().x(),height()-e->pos().y());
	}
	else {
		DragWidget::mousePressEvent(e);
	}
}

void ResizableDragWidget::mouseMoveEvent(TQMouseEvent * e)
{
	if (!rsz){
		DragWidget::mouseMoveEvent(e);
		return;
	}
	
	TQPoint curr(e->globalPos().x(),e->globalPos().y());
	TQPoint pos = TQWidget::pos();
	//TQPoint curr(e->globalPos().x()-dragP.x(),e->globalPos().y()-dragP.y());
	int nw = curr.x()-pos.x()+dragP.x();
	int nh = curr.y()-pos.y()+dragP.y();
	
	resize(nw,nh);
	
}

void ResizableDragWidget::mouseReleaseEvent(TQMouseEvent * e)
{
	if (!rsz){
		DragWidget::mouseReleaseEvent(e);
		return;
	}
	
	rsz=false;
}

void ResizableDragWidget::paintEvent(TQPaintEvent *)
{
	
	TQPainter p(this);
	
	for (int a=0;a<20;a+=5){
		
		p.setPen(TQColor(170,0,0));
		p.drawLine(width()-20+a,height()-2,width()-2,height()-20+a);
		p.setPen(TQColor(200,0,0));
		p.drawLine(width()-19+a,height()-2,width()-2,height()-19+a);
	}
	
}


