#ifndef _EDITUSER_H_
#define _EDITUSER_H_
//=============================================================================
//
//   File : edituser.h
//   Creation date : Sun Dec 24 2000 15:16:17 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2000-2004 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================

#include "kvi_string.h"
#include "kvi_regusersdb.h"
#include "kvi_selectors.h"

#include <tqwidget.h>
#include <tqlineedit.h>
#include <tqpushbutton.h>
#include "kvi_tal_listview.h"
#include "kvi_tal_listbox.h"
#include "kvi_pointerhashtable.h"
#include <kvi_tal_tabdialog.h>
#ifdef COMPILE_USE_QT4
#include <tq3table.h>
#define Kvi_Tal_Table Q3Table
#define Kvi_Tal_TableItem Q3TableItem

#else
#include <tqtable.h>
#define Kvi_Tal_Table TQTable
#define Kvi_Tal_TableItem TQTableItem

#endif
#include "kvi_tal_popupmenu.h"

#ifndef _EDITUSER_CPP_
	extern KviRegisteredUserDataBase * g_pLocalRegisteredUserDataBase;
#endif

class KviRegisteredUser;

class KviReguserPropertiesDialog : public TQDialog
{
	Q_OBJECT
  TQ_OBJECT
public:
	KviReguserPropertiesDialog(TQWidget *p,KviPointerHashTable<TQString,TQString> * dict);
	~KviReguserPropertiesDialog();
protected:
#ifdef COMPILE_USE_QT4
	Q3Table *m_pTable;
#else
	TQTable             * m_pTable;
#endif
	KviPointerHashTable<TQString,TQString>     * m_pPropertyDict;
	TQPushButton        * m_pDelButton;
	TQPushButton        * m_pAddButton;
protected:
	void fillData();
	virtual void closeEvent(TQCloseEvent *);
protected slots:
	void okClicked();
	void addClicked();
	void delClicked();
};


class KviReguserMaskDialog : public TQDialog
{
	Q_OBJECT
  TQ_OBJECT
public:
	KviReguserMaskDialog(TQWidget * p,KviIrcMask * m);
	~KviReguserMaskDialog();
protected:
	KviIrcMask * m_pMask;

	TQLineEdit * m_pNickEdit;
	TQLineEdit * m_pUserEdit;
	TQLineEdit * m_pHostEdit;
	
	virtual void closeEvent(TQCloseEvent *);
protected slots:
	void okClicked();
};


class KviRegisteredUserEntryDialog : public KviTalTabDialog
{
	Q_OBJECT
  TQ_OBJECT
public:
	KviRegisteredUserEntryDialog(TQWidget * p,KviRegisteredUser * r,bool bModal = true);
	virtual ~KviRegisteredUserEntryDialog();
protected:
	KviRegisteredUser  * m_pUser;

	TQLineEdit          * m_pNameEdit;
	TQLineEdit          * m_pCommentEdit;

	KviTalListBox           * m_pMaskListBox;

	TQPushButton        * m_pDelMaskButton;
	TQPushButton        * m_pEditMaskButton;
	TQPushButton        * m_pAddMaskButton;

	TQCheckBox          * m_pNotifyCheck;
	TQLineEdit          * m_pNotifyNick;

	KviPixmap          * m_pAvatar;
	KviPixmapSelector  * m_pAvatarSelector;

	KviPointerHashTable<TQString,TQString>     * m_pPropertyDict;
	
	TQCheckBox          * m_pCustomColorCheck;
	TQColor		   * m_pCustomColor;
	KviColorSelector   * m_pCustomColorSelector;

	//Ignore TAB
	TQCheckBox          * m_pIgnoreEnabled;
	TQCheckBox          * m_pIgnoreQuery;
	TQCheckBox          * m_pIgnoreChannel;
	TQCheckBox          * m_pIgnoreNotice;
	TQCheckBox          * m_pIgnoreCtcp;
	TQCheckBox          * m_pIgnoreInvite;
	TQCheckBox          * m_pIgnoreDcc;

	virtual void closeEvent(TQCloseEvent *);
protected slots:
	void okClicked();
	void addMaskClicked();
	void delMaskClicked();
	void editMaskClicked();
	void editAllPropertiesClicked();
	void maskCurrentChanged(KviTalListBoxItem *it);
};



#endif //_EDITUSER_H_
