//=============================================================================
//
//   File : mp_dcopinterface.cpp
//   Created on Sun 27 Mar 2005 16:56:21 by Szymon Stefanek
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 2005 Szymon Stefanek <pragma at kvirc dot net>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================

#include "mp_dcopinterface.h"

#ifdef COMPILE_KDE_SUPPORT

#include "dcopclient.h"

#include <tqdatastream.h>
#include <tqvaluelist.h>

#include "kvi_app.h"
#include "kvi_thread.h"

KviMediaPlayerDCOPInterface::KviMediaPlayerDCOPInterface(const KviTQCString &szAppId)
: KviMediaPlayerInterface()
{
	m_szAppId = szAppId;
}

KviMediaPlayerDCOPInterface::~KviMediaPlayerDCOPInterface()
{
}

bool KviMediaPlayerDCOPInterface::ensureAppRunning(const TQString &szApp)
{
	if(findRunningApp(m_szAppId))return true;
	return startApp(m_szAppId,400);
}


bool KviMediaPlayerDCOPInterface::simpleDCOPCall(const KviTQCString &szObj,const KviTQCString &szFunc)
{
	if(!ensureAppRunning(m_szAppId))return false;
	TQByteArray data;
	return g_pApp->dcopClient()->send(m_szAppId,szObj,szFunc,data);
}

bool KviMediaPlayerDCOPInterface::boolDCOPCall(const KviTQCString &szObj,const KviTQCString &szFunc,bool bVal)
{
	if(!ensureAppRunning(m_szAppId))return false;
	TQByteArray data;
	TQDataStream arg(data, IO_WriteOnly);
	arg << bVal;
	return g_pApp->dcopClient()->send(m_szAppId,szObj,szFunc,data);
}

bool KviMediaPlayerDCOPInterface::intDCOPCall(const KviTQCString &szObj,const KviTQCString &szFunc,int iVal)
{
	if(!ensureAppRunning(m_szAppId))return false;
	TQByteArray data;
	TQDataStream arg(data, IO_WriteOnly);
	arg << iVal;
	return g_pApp->dcopClient()->send(m_szAppId,szObj,szFunc,data);
}

bool KviMediaPlayerDCOPInterface::floatDCOPCall(const KviTQCString &szObj,const KviTQCString &szFunc,float fVal)
{
	if(!ensureAppRunning(m_szAppId))return false;
	TQByteArray data;
	TQDataStream arg(data, IO_WriteOnly);
	arg << fVal;
	return g_pApp->dcopClient()->send(m_szAppId,szObj,szFunc,data);
}

bool KviMediaPlayerDCOPInterface::stringDCOPCall(const KviTQCString &szObj,const KviTQCString &szFunc,TQString szVal)
{
	if(!ensureAppRunning(m_szAppId))return false;
	TQByteArray data;
	TQDataStream arg(data, IO_WriteOnly);
	arg << szVal;
	return g_pApp->dcopClient()->send(m_szAppId,szObj,szFunc,data);
}

bool KviMediaPlayerDCOPInterface::stringRetDCOPCall(const KviTQCString &szObj,const KviTQCString &szFunc,TQString &ret)
{
	if(!ensureAppRunning(m_szAppId))return false;
	TQString title;
	TQByteArray data, replyData;
	KviTQCString replyType;
	if(!g_pApp->dcopClient()->call(m_szAppId,szObj,szFunc,data,replyType,replyData))
		return false;
	TQDataStream reply( replyData, IO_ReadOnly );
	if(replyType == TQSTRING_OBJECT_NAME_STRING)
	{
		reply >> ret;
		return true;
	}
	return false;
}

bool KviMediaPlayerDCOPInterface::intRetDCOPCall(const KviTQCString &szObj,const KviTQCString &szFunc,int &ret)
{
	if(!ensureAppRunning(m_szAppId))return false;
	TQString title;
	TQByteArray data, replyData;
	KviTQCString replyType;
	if(!g_pApp->dcopClient()->call(m_szAppId,szObj,szFunc,data,replyType,replyData))
		return false;
	TQDataStream reply( replyData, IO_ReadOnly );
	if(replyType == "int")
	{
		reply >> ret;
		return true;
	}
	return false;
}

bool KviMediaPlayerDCOPInterface::boolRetDCOPCall(const KviTQCString &szObj,const KviTQCString &szFunc,bool &ret)
{
	if(!ensureAppRunning(m_szAppId))return false;
	TQString title;
	TQByteArray data, replyData;
	KviTQCString replyType;
	if(!g_pApp->dcopClient()->call(m_szAppId,szObj,szFunc,data,replyType,replyData))
		return false;
	TQDataStream reply( replyData, IO_ReadOnly );
	if(replyType == "bool")
	{
		reply >> ret;
		return true;
	}
	return false;
}


bool KviMediaPlayerDCOPInterface::findRunningApp(const TQString &szApp)
{
	TQValueList<KviTQCString> allApps = g_pApp->dcopClient() ->registeredApplications();
	TQValueList<KviTQCString>::iterator iterator;
	KviTQCString sz = szApp.local8Bit();
	for(iterator = allApps.begin();iterator != allApps.end();iterator++)
	{
		if(*iterator == sz)return true;
	}
	return false;
}

int KviMediaPlayerDCOPInterface::detectApp(const TQString &szApp,bool bStart,int iScoreWhenFound,int iScoreWhenStarted)
{
	// lookup the amarok interface
	if(!g_pApp->dcopClient())return 0;
	if(findRunningApp(szApp))return 95; // found a running amarok, no need to run further

	// no amarok app found
	if(bStart)
	{
		// try to start it
		if(!startApp(szApp,5000))return 10; // very low possibility
		return findRunningApp(szApp) ? 99 : 0; // try to find it again
	}

	return 30; // it still might be installed on the system but we're just unable to start it...
}


bool KviMediaPlayerDCOPInterface::startApp(const TQString &szApp,int iWaitMSecs)
{
	// we could use KApplication::startServiceByDesktopName here
	// but we want to be able to wait a defined amount of time
	TQStringList tmp;
	TQByteArray data, replyData;
	KviTQCString replyType;
	TQDataStream arg(data, IO_WriteOnly);
	arg << szApp << tmp;
	if(!g_pApp->dcopClient()->call(
			"klauncher",
			"klauncher",
			"start_service_by_desktop_name(TQString,TQStringList)",
			data,
			replyType,
			replyData))
	{
		return false;
	} else {
		TQDataStream reply(replyData, IO_ReadOnly);
		if(replyType != "serviceResult")return false;
		int result;
		KviTQCString dcopName;
		TQString error;
		reply >> result >> dcopName >> error;
		if(result != 0)return false;
	}
	// ok , we seem to have started it.. but it might take some seconds
	// for the app to get registered
	// we wait up to five seconds
	if(iWaitMSecs > 0)
	{
		int i = 0;
		while(i < iWaitMSecs)
		{
			if(findRunningApp(szApp))return true;
			KviThread::msleep(100);
			i += 100;
		}
		return findRunningApp(szApp);
	}
	return true;
}


#endif //COMPILE_KDE_SUPPORT
