#ifndef _LISTWINDOW_H_
#define _LISTWINDOW_H_
//=============================================================================
//
//   File : listwindow.h
//   Creation date : Thu Oct 7 2001 13:27:55 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001-2004 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the lists of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================

#include "kvi_window.h"
#include "kvi_string.h"
#include "kvi_ircsocket.h"
#include "kvi_pointerlist.h"
#include "kvi_sparser.h"
#include "kvi_console.h"
#include "kvi_irccontext.h"

#include "kvi_tal_listview.h"
#include "kvi_tal_popupmenu.h"
#include <tqtoolbutton.h>
#include <tqlineedit.h>

class KviThemedLabel;

class KviChannelListViewItemData
{
	friend class KviChannelListViewItem;
	friend class KviListWindow;
public:
	KviChannelListViewItemData(const TQString &szChan,const TQString &szUsers,const TQString &szTopic);
	~KviChannelListViewItemData();
protected:
	TQString m_szChan;
	TQString m_szUsers;
	TQString m_szTopic;
	TQString m_szUsersKey;
};

class KviChannelListViewItem : public KviTalListViewItem
{
	friend class KviListWindow;
public:
	KviChannelListViewItem(KviTalListView * v,KviChannelListViewItemData * pData);
	~KviChannelListViewItem();
protected:
	KviChannelListViewItemData * m_pData;
public:
	const TQString & channel(){ return m_pData->m_szChan; };
#ifdef COMPILE_USE_QT4
	int width ( const TQFontMetrics & fm, const KviTalListView * lv, int column ) const;
#else
	int width ( const TQFontMetrics & fm, const TQListView * lv, int column ) const;
#endif
protected:
	virtual void paintCell(TQPainter * p,const TQColorGroup &cg,int col,int wdth,int align);
	virtual TQString key(int col,bool) const;
};



class KviListWindow : public KviWindow, public KviExternalServerDataParser
{
	Q_OBJECT
  TQ_OBJECT
public:
	KviListWindow(KviFrame * lpFrm,KviConsole * lpConsole);
	~KviListWindow();
protected:
	TQSplitter                              * m_pVertSplitter;
	TQSplitter                              * m_pTopSplitter;
	KviTalListView                         * m_pListView;
	TQLineEdit                              * m_pParamsEdit;
	TQToolButton                            * m_pRequestButton;
	TQToolButton							   * m_pStopListDownloadButton;
	TQToolButton							   * m_pOpenButton;
	TQToolButton							   * m_pSaveButton;
	KviThemedLabel                         * m_pInfoLabel;
	TQTimer                                 * m_pFlushTimer;
	KviPointerList<KviChannelListViewItemData> * m_pItemList;
public: // Methods
	virtual void control(int msg);
	virtual void processData(KviIrcMessage * msg);
	virtual void die();
protected:
	virtual TQPixmap * myIconPtr();
	virtual void fillCaptionBuffers();
	virtual void applyOptions();
	virtual void resizeEvent(TQResizeEvent *e);
	virtual void getBaseLogFileName(KviStr &buffer);
protected slots:
	void flush();
	void itemDoubleClicked(KviTalListViewItem *it);
	void requestList();
	void stoplistdownload();
	void connectionStateChange();
	void exportList();
	void importList();
public:
	virtual TQSize sizeHint() const;
private:
	void reset();
	void endOfList();
	void startOfList();
};

#endif //_KVI_LISTWINDOW_H_
