#ifndef _MANAGEMENTDIALOG_H_
#define _MANAGEMENTDIALOG_H_
//=============================================================================
//
//   File : managementdialog.h
//   Created on Fri 08 Apr 2005 14:54:56 by Szymon Stefanek
//
//   This file is part of the KVIrc IRC Client distribution
//   Copyright (C) 2005 Szymon Stefanek <pragma at kvirc dot net>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================

#include <tqdialog.h>

#include "kvi_listview.h"
#include "kvi_settings.h"
#include <tqwidget.h>
#include <tqlabel.h>
#include <tqdialog.h>
#include <tqcolor.h>
#include "kvi_tal_listview.h"

class TQPushButton;
class TQPixmap;
class KviKvsScriptAddon;

#ifdef COMPILE_USE_QT4
	#include <TQTextDocument>
#else
	#include <tqsimplerichtext.h>
#endif

class KviScriptAddonListViewItem : public KviTalListViewItem
{
public:
	KviScriptAddonListViewItem(KviTalListView * v,KviKvsScriptAddon * a);
	~KviScriptAddonListViewItem();
protected:
	KviKvsScriptAddon * m_pAddon;
#ifdef COMPILE_USE_QT4
	TQTextDocument * m_pText;
#else
	TQSimpleRichText * m_pText;
#endif	
	TQPixmap * m_pIcon;
	KviTalListView * m_pListView;
	TQString m_szKey;
public:
	KviKvsScriptAddon * addon(){ return m_pAddon; };
protected:
	virtual TQString key(int,bool) const;
	virtual void paintCell(TQPainter * p,const TQColorGroup & cg,int column,int width,int align);
	virtual void setup();
};

class KviScriptAddonListView : public KviListView
{
	Q_OBJECT
  TQ_OBJECT
public:
	KviScriptAddonListView(TQWidget * pParent);
	~KviScriptAddonListView();
protected:
	virtual void resizeEvent(TQResizeEvent * e);
};

class KviScriptManagementDialog : public TQDialog
{
	Q_OBJECT
  TQ_OBJECT
protected:
	KviScriptManagementDialog(TQWidget * p);
public:
	~KviScriptManagementDialog();
protected:
	KviScriptAddonListView * m_pListView;
	static KviScriptManagementDialog * m_pInstance;
	TQPushButton * m_pUninstallButton;
	TQPushButton * m_pConfigureButton;
	TQPushButton * m_pHelpButton;
	TQPushButton * m_pInstallButton;
	TQPushButton * m_pGetScriptsButton;
public:
	static KviScriptManagementDialog * instance(){ return m_pInstance; };
	static void display();
	static void cleanup();
protected:
	void fillListView();
	virtual void showEvent(TQShowEvent * e);
	virtual void closeEvent(TQCloseEvent *e);
protected slots:
	void currentChanged(KviTalListViewItem *i);
	void closeClicked();
	void showScriptHelp();
	void configureScript();
	void uninstallScript();
	void getMoreScripts();
	void installScript();
};


#endif //!_MANAGEMENTDIALOG_H_
