//
//   File : kvi_msgbox.cpp
//   Creation date : Tue Jun 20 2000 12:49:41 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
#define __KVIRC__
#include "kvi_msgbox.h"

// FIXME: #warning "This should go into TAL as layer ...then maybe a wrapper in KviApp!"

#ifdef COMPILE_KDE_SUPPORT
	#include <kmessagebox.h>
#else
	#include <tqmessagebox.h>
#endif //!COMPILE_WITH_KDE

#include "kvi_malloc.h"
#include "kvi_string.h"
#include "kvi_locale.h"

// FIXME: #warning "This could go into KviApp"

namespace KviMessageBox
{
	void warning(const TQString &fmt,...)
	{
		kvi_va_list list;
		kvi_va_start_by_reference(list,fmt);
		TQString s;
		KviTQString::vsprintf(s,fmt,list);
		kvi_va_end(list);
#ifdef COMPILE_KDE_SUPPORT
		KMessageBox::error(0,s,"KVIrc");
#else
		TQMessageBox::warning(0,"KVIrc",s);
#endif
	}
	
	void information(const TQString &fmt,...)
	{
		kvi_va_list list;
		kvi_va_start_by_reference(list,fmt);
		TQString s;
		KviTQString::vsprintf(s,fmt,list);
		kvi_va_end(list);
#ifdef COMPILE_KDE_SUPPORT
		KMessageBox::information(0,s,"KVIrc");
#else
		TQMessageBox::information(0,"KVIrc",s);
#endif
	}
	
	bool yesNo(const TQString &caption,const TQString &fmt,...)
	{
		kvi_va_list list;
		kvi_va_start_by_reference(list,fmt);
		TQString s;
		KviTQString::vsprintf(s,fmt,list);
		kvi_va_end(list);
		bool bRet;
#ifdef COMPILE_KDE_SUPPORT
		bRet = (KMessageBox::questionYesNo(0,s,caption) == KMessageBox::Yes);
#else
		bRet = (TQMessageBox::information(0,caption,s,
				TQMessageBox::Yes | TQMessageBox::Default,
				TQMessageBox::No | TQMessageBox::Escape) == TQMessageBox::Yes);
#endif
		return bRet;
	}
};



