#ifndef _KVI_MASKEDITOR_H_
#define _KVI_MASKEDITOR_H_

//
//   File : kvi_maskeditor.h
//   Creation date : Tue Aug 30 2000 12:20:10 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//

#include "kvi_settings.h"
#include <tqdialog.h> 
#include <tqlineedit.h> 
#include <tqwidget.h>
#include "kvi_tal_listview.h"
#include <tqpushbutton.h>
#include "kvi_pointerlist.h"

#include "kvi_string.h"
#include "kvi_toolwindows_container.h"

class KviMaskEditor;
class KviChannel;

typedef struct _KviMaskEntry
{
	TQString szMask;
	TQString szSetBy;
	unsigned int uSetAt;
} KviMaskEntry;

class KviMaskItem: public KviTalListViewItem
{
public:
	KviMaskItem(KviTalListView* parent,KviMaskEntry* entry);
	~KviMaskItem();
	
	KviMaskEntry* mask() { return &m_Mask; };
#ifdef COMPILE_USE_QT4
	virtual int compare ( KviTalListViewItem * i, int col, bool ascending ) const;
#else
	virtual int compare ( TQListViewItem * i, int col, bool ascending ) const;
#endif
protected:
	KviMaskEntry m_Mask;
	
};

class KviMaskInputDialog : public TQDialog
{
	Q_OBJECT
  TQ_OBJECT
public:
	KviMaskInputDialog(const TQString &szMask,KviMaskEditor* pEditor,KviChannel * pChannel);
	~KviMaskInputDialog();
protected:
	TQLineEdit     * m_pEdit;
	TQPushButton   * m_pOkButton;
	TQPushButton   * m_pChancelButton;
	TQString 	m_szOldMask;
	KviChannel    * m_pChannel;
	KviMaskEditor * m_pEditor;
protected slots:
	virtual void accept();
};

class KVIRC_API KviMaskEditor : public KviWindowToolWidget
{
	Q_OBJECT
  TQ_OBJECT
public:
	KviMaskEditor(TQWidget * par,KviWindowToolPageButton* button,KviPointerList<KviMaskEntry> * maskList,
		char flag,const char * nam);
	~KviMaskEditor();
protected:
	KviTalListView      * m_pMaskBox;
	TQPushButton         * m_pRemoveMask;
	TQPushButton   	    * m_pAddButton;
	TQLineEdit           * m_pSearch;
	char                  m_cFlag;
	int		              m_iIconId;
public:
	char flag(){ return m_cFlag; };
	void addMask(KviMaskEntry *e);
	void removeMask(KviMaskEntry *e);
protected slots:
	void removeClicked();
	void addClicked();
	void listViewDoubleClicked( KviTalListViewItem * );
	void searchTextChanged ( const TQString & );
signals:
	void removeMasks(KviMaskEditor *,KviPointerList<KviMaskEntry> *);
};

#endif //_KVI_MASKEDITOR_H_
