#ifndef _KVI_IMAGEDIALOG_H_
#define _KVI_IMAGEDIALOG_H_
//
//   File : kvi_imagedialog.h
//   Creation date : Sun Dec 22 2002 19:42 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2002 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//

#include "kvi_settings.h"




#include <tqdialog.h>
#include <tqcombobox.h>
#include "kvi_tal_listbox.h"
#include "kvi_valuelist.h"
#include <tqtimer.h>
#include <tqstringlist.h>

#include "kvi_dynamictooltip.h"

class KviImageDialogItem : public KviTalListBoxPixmap
{
public:
	bool m_bIsFolder;
	TQString m_szImageId;
	TQString m_szTipText;
public:
	KviImageDialogItem(KviTalListBox * b,const TQPixmap &thumb,const TQString &szFile,const TQString &image_id,const TQString &szTipText = TQString(),bool bIsFolder = false)
	: KviTalListBoxPixmap(b,thumb,szFile) , m_bIsFolder(bIsFolder) , m_szImageId(image_id) , m_szTipText(szTipText) {};
	~KviImageDialogItem(){};
public:
	bool isFolder(){ return m_bIsFolder; };
	const TQString & imageId(){ return m_szImageId; };
	const TQString & tipText(){ return m_szTipText; };
	virtual int height(const KviTalListBox *) const;
	virtual int width(const KviTalListBox *) const;
	virtual void paint(TQPainter * p);
};


#define KID_TYPE_BUILTIN_IMAGES_SMALL 1
#define KID_TYPE_FULL_PATH 2

#define KID_TYPE_ALL 3

class KVIRC_API KviImageDialog : public TQDialog
{
	Q_OBJECT
  TQ_OBJECT
public:
	KviImageDialog(TQWidget * par,
		const TQString &szCaption = TQString(),
		int types = KID_TYPE_ALL,
		int initialType = 0,
		const TQString &szInitialDir = TQString(),
		int maxPreviewFileSize = 256000, bool modal=false);
	virtual ~KviImageDialog();
protected:
	TQComboBox       * m_pTypeComboBox;
	KviValueList<int> * m_pTypeList;
	KviTalListBox        * m_pListBox;
	TQTimer          * m_pTimer;
	int               m_iJobType;

	int               m_iMaxPreviewFileSize;

	TQString           m_szJobPath;
	TQStringList       m_lJobFileList;
	
	int               m_iJobIndexHelper;

	TQString           m_szSelectedImage;

	TQString           m_szInitialPath;

	KviDynamicToolTip * m_pTip;
public:
	const TQString & selectedImage(){ return m_szSelectedImage; };
protected:
	void startJob(int type,const TQString &szInitialPath = TQString());
	void jobTerminated();
	virtual void closeEvent(TQCloseEvent *e);
protected slots:
	void okClicked();
	void cancelClicked();
	void heartbeat();
	void jobTypeSelected(int index);
	void itemDoubleClicked(KviTalListBoxItem * it);
	void tipRequest(KviDynamicToolTip *,const TQPoint &pnt);
};

#endif //_KVI_IMAGEDIALOG_H_
