#ifndef _KVI_ACTIONDRAWER_H_
#define _KVI_ACTIONDRAWER_H_
//=============================================================================
//
//   File : kvi_actiondrawer.h
//   Created on Sun 21 Nov 2004 05:44:22 by Szymon Stefanek
//
//   This file is part of the KVIrc IRC Client distribution
//   Copyright (C) 2004 Szymon Stefanek <pragma at kvirc dot net>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================

#include "kvi_settings.h"
#include "kvi_qstring.h"

#include <tqwidget.h>
#include <tqtabwidget.h>

#include "kvi_listview.h"

class KviActionDrawerPage;
class TQPixmap;
#ifdef COMPILE_USE_QT4
	class Q3SimpleRichText;
#else
	class TQSimpleRichText;
#endif
class KviAction;

class KVIRC_API KviActionDrawerPageListViewItem : public KviTalListViewItem
{
public:
	KviActionDrawerPageListViewItem(KviTalListView * v,KviAction * a);
	~KviActionDrawerPageListViewItem();
protected:
	TQString m_szName;
#ifdef COMPILE_USE_QT4
	Q3SimpleRichText * m_pText;
#else
	TQSimpleRichText * m_pText;
#endif
	TQPixmap * m_pIcon;
	KviTalListView * m_pListView;
	TQString m_szKey;
public:
	TQPixmap * icon(){ return m_pIcon; };
	const TQString & name(){ return m_szName; };
protected:
	virtual void paintCell(TQPainter * p,const TQColorGroup & cg,int column,int width,int align);
	virtual void setup();
	virtual TQString key(int,bool) const;
};

class KVIRC_API KviActionDrawerPageListView : public KviListView
{
	friend class KviActionDrawerPage;
	Q_OBJECT
  TQ_OBJECT
protected:
	KviActionDrawerPageListView(KviActionDrawerPage * pParent);
public:
	~KviActionDrawerPageListView();
//protected:
//	KviActionDrawerPage * m_pPage;
protected:
	virtual void resizeEvent(TQResizeEvent * e);
	virtual void contentsMousePressEvent(TQMouseEvent * e);
};

class KVIRC_API KviActionDrawerPage : public TQWidget
{
	friend class KviActionDrawer;
	Q_OBJECT
  TQ_OBJECT
protected:
	KviActionDrawerPage(TQWidget * pParent,const TQString &szDescription);
public:
	~KviActionDrawerPage();
protected:
	KviActionDrawerPageListView * m_pListView;
protected:
	void add(KviAction * a);
};

class KVIRC_API KviActionDrawer : public TQTabWidget
{
	Q_OBJECT
  TQ_OBJECT
public:
	KviActionDrawer(TQWidget * pParent);
	~KviActionDrawer();
public:
	void fill();
};

#endif //!_KVI_ACTIONDRAWER_H_
