/***************************************************************************
 *   Copyright (C) 2003-2005 by David Saxton                               *
 *   david@bluehaze.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "cnitem.h"
#include "cnitemgroup.h"
#include "contexthelp.h"
#include "itemlibrary.h"
#include "katemdi.h"

#include <klocale.h>

#include <tqlayout.h>
#include <tqlabel.h>
#include <tqregexp.h>
#include <tqtextbrowser.h>
#include <tqwhatsthis.h>

#include <assert.h>

ContextHelp * ContextHelp::m_pSelf = 0l;

ContextHelp * ContextHelp::self( KateMDI::ToolView * parent )
{
	if (!m_pSelf)
	{
		assert(parent);
		m_pSelf = new ContextHelp(parent);
	}
	return m_pSelf;
}


ContextHelp::ContextHelp( KateMDI::ToolView * parent )
	: TQWidget( parent, "Context Help" )
{
	TQWhatsThis::add( this, i18n("Provides context-sensitive help relevant to the current editing being performed.") );
	
	TQVBoxLayout *vlayout = new TQVBoxLayout( this, 0, 6 );

	m_nameLbl = new TQLabel( this, "" );
	vlayout->addWidget(m_nameLbl);
	vlayout->addSpacing(8);
	
	m_info = new TQTextBrowser( this, "" );
	vlayout->addWidget(m_info);
	m_info->setSizePolicy( TQSizePolicy::MinimumExpanding, TQSizePolicy::MinimumExpanding );
	
	TQSpacerItem *spacer3 = new TQSpacerItem( 1, 1, TQSizePolicy::Preferred, TQSizePolicy::Preferred );
	vlayout->addItem(spacer3);
	
	slotClear();
} 


ContextHelp::~ContextHelp()
{
}


void ContextHelp::slotUpdate( Item *item )
{
	if (!item)
	{
		slotClear();
		return;
	}
	m_nameLbl->setText("<h2>"+item->name()+"</h2>");
	m_info->setText( "<b></b>"+item->description() );
}


void ContextHelp::slotClear()
{
	m_nameLbl->setText(i18n("<h2>No Item Selected</h2>"));
	m_info->setText("");
}


void ContextHelp::slotMultipleSelected()
{
	m_nameLbl->setText(i18n("<h2>Multiple Items</h2>"));
	m_info->setText("");
}


void ContextHelp::setContextHelp(const TQString& name, const TQString& help)
{
	m_nameLbl->setText("<h2>"+name+"</h2>");
	TQString parsed = help;
	parseInfo(parsed);
	m_info->setText( "<b></b>"+parsed );
}

void ContextHelp::parseInfo( TQString &info )
{
	info.replace("<example>","<br><br><b>Example:</b><blockquote>");
	info.replace("</example>","</blockquote>");
}

#include "contexthelp.moc"
