/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/


#include <tqpair.h>

#include <klocale.h>
#include <kmessagebox.h>

#include "xorgReader.h"

#define CONFIG_FILE_LOG_LEVEL_ICON "configure"
#define DEFAULT_SETTING_LOG_LEVEL_ICON "configure_toolbars"
#define COMMAND_LINE_LOG_LEVEL_ICON "konsole"
#define PROBED_LOG_LEVEL_ICON "wizard"
#define NOT_IMPLEMENTED_LOG_LEVEL_ICON "filenew"

XorgReader::XorgReader(TQObject *parent, const char *name) : 
	DefaultReader(parent, name),
	newLineTime(),
	newLineDate(TQDate::currentDate()),
	lineCount(1)
	{
	
	initializeTypeName();
}


XorgReader::~XorgReader() {

}


void XorgReader::initColumns(LogViewColumns* columns) {
	lineCount=1;
	
	columns->append(new LogViewColumn(i18n("Line"), false, false));
	columns->append(new LogViewColumn(i18n("Type"), false, false));
	columns->append(new LogViewColumn(i18n("Message"), false, false));
	
	columns->setGroupByDay(false);
	columns->setGroupByHour(false);

}

LogLine* XorgReader::parseMessage(TQString& string, LogFile* originalFile) {
	TQString type;
	
	type=string.left(4);
	
	LogLevel* logLineType=this->getTypeName(type);

	//If the type is not empty, the log message has a type, so we can delete it
	if (logLineType!=NULL) {
		string=string.remove(0, 5);
	}
	else {
		logLineType=Globals::informationLogLevel;
	}
	
	TQStringList list;
	//list.append(i18n("# %1").arg(lineCount));
	list.append(logLineType->name);
	list.append(string);
	
	lineCount++;
	
	//Substracts 1 millisec to the line time, to allow sorting
	newLineTime=newLineTime.addMSecs(-1);
	
	TQString filePath=originalFile->url.path();
	LogLine* logLine=new LogLine(newLineDate, newLineTime, list, filePath, logLineType, Globals::xorgMode->id);
	
	return(logLine);
}

void XorgReader::initializeTypeName() {
	xorgLevels["(--)"]=new LogLevel(20, i18n("probed"), PROBED_LOG_LEVEL_ICON, TQColor(240, 220, 3));
	xorgLevels["(**)"]=new LogLevel(21, i18n("from config file"), CONFIG_FILE_LOG_LEVEL_ICON, TQColor(161, 133, 240));
	xorgLevels["(==)"]=new LogLevel(22, i18n("default setting"), DEFAULT_SETTING_LOG_LEVEL_ICON, TQColor(169, 189, 165));
	xorgLevels["(++)"]=new LogLevel(23, i18n("from command Line"), COMMAND_LINE_LOG_LEVEL_ICON, TQColor(179, 181, 214));
	xorgLevels["(!!)"]=Globals::noticeLogLevel;
	xorgLevels["(II)"]=Globals::informationLogLevel;
	xorgLevels["(WW)"]=Globals::warningLogLevel;
	xorgLevels["(EE)"]=Globals::errorLogLevel;
	xorgLevels["(NI)"]=new LogLevel(24, i18n("not implemented"), NOT_IMPLEMENTED_LOG_LEVEL_ICON, TQColor(136, 146, 240));
	xorgLevels["(\?\?)"]=Globals::noneLogLevel;

}

LogLevel* XorgReader::getTypeName(const TQString type) {
	TQMap<TQString, LogLevel*>::iterator it;
	
	it=xorgLevels.find(type);
	if (it!=xorgLevels.end())
		return(*it);
	else
		return(NULL);

}

#include "xorgReader.moc"
