/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/


#ifndef VIEW_H
#define VIEW_H

//TQt includes
#include <tqwidget.h>
#include <tqdatetime.h>

//KDE includes
#include <ktoolbarbutton.h>
#include <kicondialog.h>
#include <klistview.h>

//For compatibility with old versions of KDE
#include <kdeversion.h>

//The filter is activated only if KDE version >= 3.3
#if defined(KDE_MAKE_VERSION) && (KDE_VERSION >= KDE_MAKE_VERSION(3,3,0))
#include "logLineFilter.h"
#endif

#include <kconfig.h>

#include <ksystemlogiface.h>
#include <kparts/part.h>

#include "globals.h"
#include "logListItem.h"
#include "logManager.h"

#include "logViewColumn.h"
#include "logViewColumns.h"

class ViewToolTip;

/**
 * This is the main view class for KSystemLog.
 * This class is encapsulated in a LogManager, with a Reader (in a standard LogManager)
 *
 *
 * @short Main view
 * @author Nicolas Ternisien <nicolas.ternisien@gmail.com>
 * @version 0.1
 */
class View : public TQWidget, public KSystemLogInterface {
	
	Q_OBJECT
  TQ_OBJECT

	public:
		/**
		 * Default constructor
		 */
		View(TQWidget *parent);
	
		/**
		 * Destructor
		 */
		virtual ~View();
	
		void clearLogList();
		
		void addElement(TQStringList* entries, TQPixmap* icon=NULL);
		void addElementAtEnd(TQStringList* entries, TQPixmap* icon=NULL);
		
		void setColumns(LogViewColumns* list);
		
		void setFirstItemSelected();
		void setLastItemSelected();

		void setLastItemVisible();
		void setFirstItemVisible();
	
		void toggleFilterBar();

		LogListItem* getFirstSelectedItem();
		LogListItem* getLastSelectedItem();
		
		int getItemCount();
		
		void setSortEnabled(bool enabled);
		
		void setLogManager(LogManager* manager);
		
		bool isTooltipEnabled();
		
		KListView* getLogList();
		
		void saveConfig();
		
		/**
		 * Delete the "count" first items
		 */
		void deleteOldItems(int count);
		
		/**
		* Print this view to any medium -- paper or not
		*/
		void print(TQPainter *, int height, int width);
		
		/**
		 * Method from DCOP Interface
		 */
		virtual void openURL(TQString url);

	private:

		void initLogList();
		
		void initSearchFilter(TQWidget* filterBox);
			
	signals:
		/**
		* Use this signal to change the content of the statusbar
		*/
		void changeStatusbar(const TQString& text);
		
		/**
		* Use this signal to change the content of the caption
		*/
		void changeCaption(const TQString& text);
	
	private slots:
		void slotOnURL(const TQString& url);
		void slotSetTitle(const TQString& title);
		
		void changeColumnFilter(int column);
		
		void updateList();
		void updateSearchFilter();
		


	private:
		
		LogViewColumns* columns;
		
		ViewToolTip* toolTip;
		
		bool firstLoad;
		
		
		LogManager* logManager;
		
		/**
		 * Central table
		 */
		KListView* table;
		
#if defined(KDE_MAKE_VERSION) && (KDE_VERSION >= KDE_MAKE_VERSION(3,3,0))
		TQHBox* filterBar;
		
		KToolBarButton* clearSearch;
		
		/**
		 * Search line (inherits from KListViewSearchLine)
		 */
		LogLineFilter* search;
			
		/**
		 * Filter of the column list
		 */
		TQComboBox* searchFilter;
#endif

	
};

#endif // VIEW_H

