/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef _SPECIFIC_FILE_LIST_H_
#define _SPECIFIC_FILE_LIST_H_

#include <tqstringlist.h>
#include <tqstring.h>

#include "globals.h"

#include "fileList.h"


class SpecificFileList : public FileList {

	Q_OBJECT
  TQ_OBJECT
	
	public:
		SpecificFileList(TQWidget *parent, TQString description);
		~SpecificFileList();
		
		virtual void insertItem(TQString& item);
		void insertItem(LogLevel* level, TQString& item);
		virtual void removeItem(int id);

		LogLevel* getLevel(int i);

		void saveConfig(TQStringList& filePaths, TQValueList<int>& fileLevels);
		void readConfig(TQStringList& filePaths, TQValueList<int>& fileLevels);


	protected:
		virtual bool updateButtons();

		virtual void addItem();
		
	private slots:
		void changeItemType();
		
	private:
		TQPushButton* changeItem;
		
		TQMap<TQListBoxItem*, int> levels;
	

};

#endif //_SPECIFIC_FILE_LIST_H_
