/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/


#include <tqlayout.h>
#include <tqlabel.h>


#include <klocale.h>
#include <kdialogbase.h>
#include <kiconloader.h>
#include <kapplication.h>
#include <kstandarddirs.h>
#include <kdebug.h>

#include "ksystemlogConfig.h"

#include "options.h"


Options::Options(TQWidget* parent, const char *name, bool modal) :
	KDialogBase(IconList, i18n("Configuration"), Ok|Apply|Cancel, Ok, parent, name, modal, true)
	{

	this->setMinimumSize(640, 500);
	
	setupGeneralOptions();
	
	setupSystemOptions();
	setupBootAuthenticationOptions();
	setupKernelOptions();
	setupCronOptions();
	setupDaemonOptions();
	
	setupXorgOptions();
	setupAcpidOptions();
	setupCupsOptions();
	
	setupApacheOptions();
	setupMailOptions();
	
	disableApplyButton();

	connect(this, TQT_SIGNAL(applyClicked()), this, TQT_SLOT(saveConfig()));
	connect(this, TQT_SIGNAL(okClicked()), this, TQT_SLOT(saveConfig()));
	
	
	//Really update size of this Configuration Dialog Box
	this->adjustSize();
}

Options::~Options() {
	//TODO Delete option frames
}


void Options::disableApplyButton() {
	this->enableButtonApply(false);
}

void Options::saveConfig() {
	kdDebug() << "Saving config from Main Config Dialog..." << endl;

	KSystemLogConfig::writeConfig();
	
	kdDebug() << "Configuration synchronized" << endl;
	
	disableApplyButton();
}

void Options::setupGeneralOptions() {
	TQFrame* frame=addPage(i18n("General"), i18n("General"), DesktopIcon(KSYSTEMLOG_ICON));
	
	TQGridLayout* frameLayout=new TQGridLayout(frame);
	frameLayout->setSpacing(0);
	frameLayout->setMargin(0);
	frameLayout->setAutoAdd(true);
	
	TQScrollView* container = new TQScrollView(frame);
	container->setResizePolicy(TQScrollView::AutoOneFit);
	container->setFrameShadow(TQScrollView::Plain);
	container->setFrameShape(TQScrollView::MenuBarPanel);
	container->setLineWidth(0);
	container->setMidLineWidth(0);
	
	generalOptions = new GeneralOptions(container->viewport());
	container->addChild(generalOptions, 0, 0);
	
	//Done by the setAutoAdd method
	//frameLayout->addWidget(container, 0, 0, 0);

	connect(generalOptions, TQT_SIGNAL(optionsChanged(bool)), this, TQT_SLOT(optionsChanged(bool)));

	connect(this, TQT_SIGNAL(applyClicked()), generalOptions, TQT_SLOT(saveConfig()));
	connect(this, TQT_SIGNAL(okClicked()), generalOptions, TQT_SLOT(saveConfig()));

}


void Options::setupBootAuthenticationOptions() {
	TQFrame* frame=addPage(i18n("Boot / Authentication"), i18n("Boot & Authentication Logs"), DesktopIcon(BOOT_MODE_ICON));
	
	TQGridLayout* frameLayout=new TQGridLayout(frame);
	frameLayout->setSpacing(0);
	frameLayout->setMargin(0);
	frameLayout->setAutoAdd(true);
	
	TQScrollView* container = new TQScrollView(frame);
	container->setResizePolicy(TQScrollView::AutoOneFit);
	container->setFrameShadow(TQScrollView::Plain);
	container->setFrameShape(TQScrollView::MenuBarPanel);
	container->setLineWidth(0);
	container->setMidLineWidth(0);
	
	bootAuthenticationOptions = new BootAuthenticationOptions(container->viewport());
	container->addChild(bootAuthenticationOptions, 0, 0);

	connect(bootAuthenticationOptions, TQT_SIGNAL(optionsChanged(bool)), this, TQT_SLOT(optionsChanged(bool)));

	connect(this, TQT_SIGNAL(applyClicked()), bootAuthenticationOptions, TQT_SLOT(saveConfig()));
	connect(this, TQT_SIGNAL(okClicked()), bootAuthenticationOptions, TQT_SLOT(saveConfig()));

}


void Options::setupSystemOptions() {
	TQFrame* frame=addPage(i18n("System Log"), i18n("System Log"), DesktopIcon(SYSTEM_MODE_ICON));
	
	TQGridLayout* frameLayout=new TQGridLayout(frame);
	frameLayout->setSpacing(0);
	frameLayout->setMargin(0);
	frameLayout->setAutoAdd(true);
	
	TQScrollView* container=new TQScrollView(frame);
	
	
	container->setResizePolicy(TQScrollView::AutoOneFit);
	container->setFrameShadow(TQScrollView::Plain);
	container->setFrameShape(TQScrollView::MenuBarPanel);
	container->setLineWidth(0);
	container->setMidLineWidth(0);
	
	systemOptions=new SystemOptions(container->viewport());
	container->addChild(systemOptions, 0, 0);
	
	//Done by the setAutoAdd method
	//frameLayout->addWidget(container, 0, 0, 0);

	connect(systemOptions, TQT_SIGNAL(optionsChanged(bool)), this, TQT_SLOT(optionsChanged(bool)));

	connect(this, TQT_SIGNAL(applyClicked()), systemOptions, TQT_SLOT(saveConfig()));
	connect(this, TQT_SIGNAL(okClicked()), systemOptions, TQT_SLOT(saveConfig()));
}

void Options::setupKernelOptions() {
	TQFrame* frame=addPage(i18n("Kernel Log"), i18n("Kernel Log"), DesktopIcon(KERNEL_MODE_ICON));
	
	TQGridLayout* frameLayout=new TQGridLayout(frame);
	frameLayout->setSpacing(0);
	frameLayout->setMargin(0);
	frameLayout->setAutoAdd(true);
	
	TQScrollView* container=new TQScrollView(frame);
	container->setResizePolicy(TQScrollView::AutoOneFit);
	container->setFrameShadow(TQScrollView::Plain);
	container->setFrameShape(TQScrollView::MenuBarPanel);
	container->setLineWidth(0);
	container->setMidLineWidth(0);
	
	kernelOptions=new KernelOptions(container->viewport());
	container->addChild(kernelOptions, 0, 0);
	
	//Done by the setAutoAdd method
	//frameLayout->addWidget(container, 0, 0, 0);

	connect(kernelOptions, TQT_SIGNAL(optionsChanged(bool)), this, TQT_SLOT(optionsChanged(bool)));

	connect(this, TQT_SIGNAL(applyClicked()), kernelOptions, TQT_SLOT(saveConfig()));
	connect(this, TQT_SIGNAL(okClicked()), kernelOptions, TQT_SLOT(saveConfig()));
}

void Options::setupCronOptions() {
	TQFrame* frame=addPage(i18n("Planned Tasks Cron Log"), i18n("Planned Tasks Cron Log"), DesktopIcon(CRON_MODE_ICON));
	
	TQGridLayout* frameLayout=new TQGridLayout(frame);
	frameLayout->setSpacing(0);
	frameLayout->setMargin(0);
	frameLayout->setAutoAdd(true);
	
	TQScrollView* container=new TQScrollView(frame);
	container->setResizePolicy(TQScrollView::AutoOneFit);
	container->setFrameShadow(TQScrollView::Plain);
	container->setFrameShape(TQScrollView::MenuBarPanel);
	container->setLineWidth(0);
	container->setMidLineWidth(0);
	
	cronOptions=new CronOptions(container->viewport());
	container->addChild(cronOptions, 0, 0);
	
	//Done by the setAutoAdd method
	//frameLayout->addWidget(container, 0, 0, 0);

	connect(cronOptions, TQT_SIGNAL(optionsChanged(bool)), this, TQT_SLOT(optionsChanged(bool)));

	connect(this, TQT_SIGNAL(applyClicked()), cronOptions, TQT_SLOT(saveConfig()));
	connect(this, TQT_SIGNAL(okClicked()), cronOptions, TQT_SLOT(saveConfig()));
}

void Options::setupDaemonOptions() {
	TQFrame* frame=addPage(i18n("Daemons Log"), i18n("Daemons Log"), DesktopIcon(DAEMON_MODE_ICON));
	
	TQGridLayout* frameLayout=new TQGridLayout(frame);
	frameLayout->setSpacing(0);
	frameLayout->setMargin(0);
	frameLayout->setAutoAdd(true);
	
	TQScrollView* container=new TQScrollView(frame);
	container->setResizePolicy(TQScrollView::AutoOneFit);
	container->setFrameShadow(TQScrollView::Plain);
	container->setFrameShape(TQScrollView::MenuBarPanel);
	container->setLineWidth(0);
	container->setMidLineWidth(0);
	
	daemonOptions=new DaemonOptions(container->viewport());
	container->addChild(daemonOptions, 0, 0);
	
	//Done by the setAutoAdd method
	//frameLayout->addWidget(container, 0, 0, 0);

	connect(daemonOptions, TQT_SIGNAL(optionsChanged(bool)), this, TQT_SLOT(optionsChanged(bool)));

	connect(this, TQT_SIGNAL(applyClicked()), daemonOptions, TQT_SLOT(saveConfig()));
	connect(this, TQT_SIGNAL(okClicked()), daemonOptions, TQT_SLOT(saveConfig()));
}

void Options::setupXorgOptions() {
	TQFrame* frame=addPage(i18n("X.org Log"), i18n("X.org Log"), DesktopIcon(XORG_MODE_ICON));
	
	TQGridLayout* frameLayout=new TQGridLayout(frame);
	frameLayout->setSpacing(0);
	frameLayout->setMargin(0);
	frameLayout->setAutoAdd(true);
	
	TQScrollView* container=new TQScrollView(frame);
	container->setResizePolicy(TQScrollView::AutoOneFit);
	container->setFrameShadow(TQScrollView::Plain);
	container->setFrameShape(TQScrollView::MenuBarPanel);
	container->setLineWidth(0);
	container->setMidLineWidth(0);
	
	xorgOptions=new XorgOptions(container->viewport());
	container->addChild(xorgOptions, 0, 0);
	
	//Done by the setAutoAdd method
	//frameLayout->addWidget(container, 0, 0, 0);

	connect(xorgOptions, TQT_SIGNAL(optionsChanged(bool)), this, TQT_SLOT(optionsChanged(bool)));

	connect(this, TQT_SIGNAL(applyClicked()), xorgOptions, TQT_SLOT(saveConfig()));
	connect(this, TQT_SIGNAL(okClicked()), xorgOptions, TQT_SLOT(saveConfig()));

}


void Options::setupAcpidOptions() {
	TQFrame* frame=addPage(i18n("ACPI Log"), i18n("ACPI Daemon Log"), DesktopIcon(ACPID_MODE_ICON));
	
	TQGridLayout* frameLayout=new TQGridLayout(frame);
	frameLayout->setSpacing(0);
	frameLayout->setMargin(0);
	frameLayout->setAutoAdd(true);
	
	TQScrollView* container=new TQScrollView(frame);
	container->setResizePolicy(TQScrollView::AutoOneFit);
	container->setFrameShadow(TQScrollView::Plain);
	container->setFrameShape(TQScrollView::MenuBarPanel);
	container->setLineWidth(0);
	container->setMidLineWidth(0);
	
	acpidOptions=new AcpidOptions(container->viewport());
	container->addChild(acpidOptions, 0, 0);
	
	//Done by the setAutoAdd method
	//frameLayout->addWidget(container, 0, 0, 0);

	connect(acpidOptions, TQT_SIGNAL(optionsChanged(bool)), this, TQT_SLOT(optionsChanged(bool)));

	connect(this, TQT_SIGNAL(applyClicked()), acpidOptions, TQT_SLOT(saveConfig()));
	connect(this, TQT_SIGNAL(okClicked()), acpidOptions, TQT_SLOT(saveConfig()));

}


void Options::setupCupsOptions() {
	TQFrame* frame=addPage(i18n("CUPS Log"), i18n("CUPS & CUPS Web Server Log"), DesktopIcon(CUPS_MODE_ICON));
	
	TQGridLayout* frameLayout=new TQGridLayout(frame);
	frameLayout->setSpacing(0);
	frameLayout->setMargin(0);
	frameLayout->setAutoAdd(true);
	
	TQScrollView* container=new TQScrollView(frame);
	container->setResizePolicy(TQScrollView::AutoOneFit);
	container->setFrameShadow(TQScrollView::Plain);
	container->setFrameShape(TQScrollView::MenuBarPanel);
	container->setLineWidth(0);
	container->setMidLineWidth(0);
	
	cupsOptions=new CupsOptions(container->viewport());
	container->addChild(cupsOptions, 0, 0);
	
	//Done by the setAutoAdd method
	//frameLayout->addWidget(container, 0, 0, 0);

	connect(cupsOptions, TQT_SIGNAL(optionsChanged(bool)), this, TQT_SLOT(optionsChanged(bool)));

	connect(this, TQT_SIGNAL(applyClicked()), cupsOptions, TQT_SLOT(saveConfig()));
	connect(this, TQT_SIGNAL(okClicked()), cupsOptions, TQT_SLOT(saveConfig()));

}

void Options::setupApacheOptions() {
	TQFrame* frame=addPage(i18n("Apache Log"), i18n("Apache and Web Access Logs"), DesktopIcon(APACHE_MODE_ICON));
	
	TQGridLayout* frameLayout=new TQGridLayout(frame);
	frameLayout->setSpacing(0);
	frameLayout->setMargin(0);
	frameLayout->setAutoAdd(true);
	
	TQScrollView* container=new TQScrollView(frame);
	container->setResizePolicy(TQScrollView::AutoOneFit);
	container->setFrameShadow(TQScrollView::Plain);
	container->setFrameShape(TQScrollView::MenuBarPanel);
	container->setLineWidth(0);
	container->setMidLineWidth(0);
	
	apacheOptions=new ApacheOptions(container->viewport());
	container->addChild(apacheOptions, 0, 0);
	
	//Done by the setAutoAdd method
	//frameLayout->addWidget(container, 0, 0, 0);

	connect(apacheOptions, TQT_SIGNAL(optionsChanged(bool)), this, TQT_SLOT(optionsChanged(bool)));

	connect(this, TQT_SIGNAL(applyClicked()), apacheOptions, TQT_SLOT(saveConfig()));
	connect(this, TQT_SIGNAL(okClicked()), apacheOptions, TQT_SLOT(saveConfig()));

}


void Options::setupMailOptions() {
	TQFrame* frame=addPage(i18n("Mail Log"), i18n("Mail Log"), DesktopIcon(MAIL_MODE_ICON));
	
	TQGridLayout* frameLayout=new TQGridLayout(frame);
	frameLayout->setSpacing(0);
	frameLayout->setMargin(0);
	frameLayout->setAutoAdd(true);
	
	TQScrollView* container=new TQScrollView(frame);
	container->setResizePolicy(TQScrollView::AutoOneFit);
	container->setFrameShadow(TQScrollView::Plain);
	container->setFrameShape(TQScrollView::MenuBarPanel);
	container->setLineWidth(0);
	container->setMidLineWidth(0);
	
	mailOptions=new MailOptions(container->viewport());
	container->addChild(mailOptions, 0, 0);
	
	//Done by the setAutoAdd method
	//frameLayout->addWidget(container, 0, 0, 0);

	connect(mailOptions, TQT_SIGNAL(optionsChanged(bool)), this, TQT_SLOT(optionsChanged(bool)));

	connect(this, TQT_SIGNAL(applyClicked()), mailOptions, TQT_SLOT(saveConfig()));
	connect(this, TQT_SIGNAL(okClicked()), mailOptions, TQT_SLOT(saveConfig()));
}


void Options::optionsChanged(bool valid) {
	if (valid==false) {
		this->enableButtonApply(false);
		this->enableButtonOK(false);
	}
	else {
		//If all tab options are valid, then, we reactivate the Apply and OK buttons
		if (generalOptions->isValid() &&
			systemOptions->isValid() &&
			cronOptions->isValid() &&
			daemonOptions->isValid() &&
			kernelOptions->isValid() &&
			xorgOptions->isValid() && 
			acpidOptions->isValid() && 
			cupsOptions->isValid() && 
			bootAuthenticationOptions->isValid()) {
			
			this->enableButtonApply(true);
			this->enableButtonOK(true);
			
		}
		else {
			this->enableButtonApply(true);
			this->enableButtonOK(true);
		}
	}
}

#include "options.moc"

