/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
 
#ifndef _GENERAL_OPTIONS_H_
#define _GENERAL_OPTIONS_H_

#include <tqframe.h>
#include <tqspinbox.h>
#include <tqbuttongroup.h>
#include <tqcheckbox.h>

#include <kconfig.h>
#include <kdialogbase.h>

#include "globals.h"


class GeneralOptions : public TQWidget {
	Q_OBJECT
  TQ_OBJECT
	public:
		GeneralOptions(TQWidget *parent = 0);
		
		bool isValid();

	public slots:
		void saveConfig();
		void readConfig();

	signals:
		void optionsChanged(bool valid);
	
	private slots:
		void onOptionsChanged();
		
	private:		
		TQSpinBox* maxLines;
		TQSpinBox* maxCharacters;
		TQCheckBox* deleteDuplicatedLines;
		
		TQCheckBox* deleteProcessId;
		TQCheckBox* colorizeLogLines;
};

#endif // _GENERAL_PREFERENCES_H_
