/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/



#include <tqlayout.h>
#include <tqlabel.h>
#include <tqvgroupbox.h>
#include <tqbutton.h>
#include <tqradiobutton.h>
#include <tqwhatsthis.h>
#include <tqtooltip.h>

#include <klocale.h>
#include <kdialogbase.h>
#include <kiconloader.h>
#include <kapplication.h>
#include <kstandarddirs.h>
#include <kdebug.h>

#include "ksystemlogConfig.h"
#include "generalOptions.h"

GeneralOptions::GeneralOptions(TQWidget *parent) : 
	TQWidget(parent) 
	{

	TQVBoxLayout *layout = new TQVBoxLayout(this);
	layout->setSpacing(10);
	
	//Maximum Lines
	TQVGroupBox* logLinesBox=new TQVGroupBox(i18n("Log Lines List"), this);
	new TQLabel(i18n("Maximum lines displayed:"), logLinesBox);
	maxLines=new TQSpinBox(10, 30000, 10, logLinesBox);
	connect(maxLines, TQT_SIGNAL(valueChanged(int)), this, TQT_SLOT(onOptionsChanged()));
	
	TQToolTip::add(maxLines, i18n("<qt>Choose here the maximum number of log lines displayed in the main view.</qt>"));
	TQWhatsThis::add(maxLines, i18n("<qt>You can choose here the maximum number of log lines displayed in the main view.</qt>"));

	deleteDuplicatedLines=new TQCheckBox(i18n("Delete duplicated log lines (may be slow)"), logLinesBox);
	connect(deleteDuplicatedLines, TQT_SIGNAL(clicked()), this, TQT_SLOT(onOptionsChanged()));
	
	TQToolTip::add(deleteDuplicatedLines, i18n("<qt>Select this option if you want to delete duplicated log lines <b>(may be slow)</b>.</qt>"));
	TQWhatsThis::add(deleteDuplicatedLines, i18n("<qt>You can select this option if you want to delete duplicated log lines. <b>This option can slow the reading</b>.</qt>"));


	
	//Maximum Characters per line
	TQVGroupBox* maxCharBox=new TQVGroupBox(i18n("Maximum Characters to Read per Line"), this);
	new TQLabel(i18n("Number of characters:"), maxCharBox);
	maxCharacters=new TQSpinBox(10, 30000, 10, maxCharBox);
	connect(maxCharacters, TQT_SIGNAL(valueChanged(int)), this, TQT_SLOT(onOptionsChanged()));

	TQToolTip::add(maxCharacters, i18n("<qt>Choose here the maximum number of characters to read from each log line.</qt>"));
	TQWhatsThis::add(maxCharacters, i18n("<qt>You can choose here the maximum number of characters to read from each log line.</qt>")); 
	

	TQVGroupBox* options= new TQVGroupBox( i18n( "Options" ), this );
	
	deleteProcessId=new TQCheckBox(i18n("Delete process identifier from process name"), options);
	connect(deleteProcessId, TQT_SIGNAL(clicked()), this, TQT_SLOT(onOptionsChanged()));
	
	TQToolTip::add(deleteProcessId, i18n("<qt>Delete process identifier from process name.</qt>"));
	TQWhatsThis::add(deleteProcessId, i18n("<qt>You can select this option if you want to delete the process identifier from process name. For example, you will sometimes see in the <b>Process</b> column something like <i>cron<b>[3433]</b></i>. If this option is activated, the annoying bold part will be erased.</qt>"));

	colorizeLogLines=new TQCheckBox(i18n("Colorize log lines"), options);
	connect(colorizeLogLines, TQT_SIGNAL(clicked()), this, TQT_SLOT(onOptionsChanged()));
	
	TQToolTip::add(colorizeLogLines, i18n("<qt>This option allows the colorization of log lines, depending on their log level.</qt>"));
	TQWhatsThis::add(colorizeLogLines, i18n("<qt>This option allows the colorization of log lines, depending on their log level. For example, an error will be in red, a warning in orange... This will help you to better see problems.</qt>"));
	
	TQSpacerItem* spacer=new TQSpacerItem(0, 0, TQSizePolicy::Preferred, TQSizePolicy::Expanding);

	layout->addWidget(logLinesBox);
	layout->addWidget(maxCharBox);
	layout->addWidget(options);
	
	layout->addItem(spacer);
	
	readConfig();
}


void GeneralOptions::readConfig() {
	int value;
	
	value=KSystemLogConfig::maxLines();
	maxLines->setValue(value);

	value=KSystemLogConfig::maxReadCharacters();
	maxCharacters->setValue(value);
	
	bool option=KSystemLogConfig::deleteDuplicatedLines();
	deleteDuplicatedLines->setChecked(option);

	option=KSystemLogConfig::deleteProcessIdentifier();
	deleteProcessId->setChecked(option);

	option=KSystemLogConfig::colorizeLogLines();
	colorizeLogLines->setChecked(option);

}

void GeneralOptions::saveConfig() {
	kdDebug() << "Save config from General preferences" << endl;
	
	KSystemLogConfig::setMaxLines(maxLines->value());
	KSystemLogConfig::setMaxReadCharacters(maxCharacters->value());
	KSystemLogConfig::setDeleteDuplicatedLines(deleteDuplicatedLines->isChecked());
	KSystemLogConfig::setDeleteProcessIdentifier(deleteProcessId->isChecked());
	KSystemLogConfig::setColorizeLogLines(colorizeLogLines->isChecked());

}

bool GeneralOptions::isValid() {
	return(maxLines->value()>0 && maxCharacters->value()>0);
}


void GeneralOptions::onOptionsChanged() {
	emit optionsChanged(true);
}



#include "generalOptions.moc"
