/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef _DETAIL_DIALOG_H_
#define _DETAIL_DIALOG_H_

#include <tqwidget.h>
#include <tqpushbutton.h>
#include <tqlabel.h>

#include <kdialogbase.h>
#include <kactivelabel.h>
#include <kiconloader.h>

#include "detailDialogBase.h"

#include "view.h"
#include "logListItem.h"

class DetailDialog : public DetailDialogBase {

	Q_OBJECT
  TQ_OBJECT
	
	public:
		DetailDialog(View* v, TQWidget *parent=NULL, const char* name=NULL);
		
		~DetailDialog();
		
		void setView(View* view);
	
	public slots:
		void selectionChanged();
		
	protected slots:
		void previousItem();
		void closeDetails();
		void nextItem();
		
	private:
		void updateDetails();
		
	private:
	
		//KActiveLabel* header;
		/*
		TQLabel* header;
		
		TQTextEdit* message;
		TQLabel* icon;
		
		TQPushButton* previous;
		TQPushButton* next;
		*/
		View* view;
		LogListItem* currentLine;
		

};

#endif //_DETAIL_DIALOG_H_
