/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#ifndef _DEFAULT_READER_H_
#define _DEFAULT_READER_H_

#include <tqobject.h>
#include <tqstringlist.h>
#include <tqfile.h>
#include <tqdatetime.h>

#include <kurl.h>
#include <kdebug.h>

#include "view.h"
#include "globals.h"

#include "reader.h"

#include "logLine.h"
#include "logLineList.h"
#include "logLineTree.h"

#include "logFile.h"


/**
 * @author Nicolas Ternisien
 */
class DefaultReader : public Reader {
	Q_OBJECT
  TQ_OBJECT
	
	public:
		DefaultReader(TQObject *parent = 0, const char *name = 0);
		
		virtual ~DefaultReader();
		
		virtual void readLog();
		
		virtual void logChanged(LogFile* file);
		
	protected:
		virtual LogLine* parseMessage(TQString& logLine, LogFile* originalFile);

		void readFile(LogFile* logFile);
		
		virtual TQStringList* getRawBuffer(TQFile* file);

		LogLineList* buffers;

		bool tmpDeleteDuplicate;
		bool tmpDeleteProcessId;
		int tmpMaxLines;
		int tmpMaxCharacters;
		
	private:

		//Returns false if the line has not been inserted
		bool insertLine(TQString& buffer, LogFile* originalFile);

		//Returns false if the line has not been inserted
		bool insertOrReplaceLine(TQString& buffer, LogFile* originalFile);

};

#endif // _DEFAULT_READER_H_
