/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#include <klocale.h>
#include <kmessagebox.h>

#include "parsingHelper.h"
#include "apacheAccessReader.h"

ApacheAccessReader::ApacheAccessReader(TQObject *parent, const char *name) :
	DefaultReader(parent, name)
	{
}


ApacheAccessReader::~ApacheAccessReader() {

}


void ApacheAccessReader::initColumns(LogViewColumns* columns) {
	columns->append(new LogViewColumn(i18n("Date"), true, false));
	columns->append(new LogViewColumn(i18n("Host Name"), true, true));
	columns->append(new LogViewColumn(i18n("Id."), true, true)); //=Identification protocol [From RFC1413 (see Google for more infos)]
	columns->append(new LogViewColumn(i18n("User"), true, true));
	columns->append(new LogViewColumn(i18n("Response"), true, true));
	columns->append(new LogViewColumn(i18n("Bytes Sent"), true, false));
	columns->append(new LogViewColumn(i18n("Agent Identity"), true, true));
	columns->append(new LogViewColumn(i18n("HTTP Request"), true, false));
	columns->append(new LogViewColumn(i18n("URL"), true, true));

}

LogLine* ApacheAccessReader::parseMessage(TQString& logLine, LogFile* logFile) {
	int spacePos=logLine.find(' ');
	
	TQString hostName=logLine.left(spacePos);	
	logLine=logLine.remove(0, spacePos+1);
	
	spacePos=logLine.find(' ');
	TQString identd=logLine.left(spacePos);
	logLine=logLine.remove(0, spacePos+1);
	
	spacePos=logLine.find(' ');
	TQString userName=logLine.left(spacePos);
	logLine=logLine.remove(0, spacePos+1);

	int endDate=logLine.find(']');
	TQString strDateTime=logLine.left(endDate);
	logLine=logLine.remove(0, endDate+3);
	
	TQDateTime dateTime=ParsingHelper::parseDateTimeFromHTTP(strDateTime);
	TQDate date=dateTime.date();
	TQTime time=dateTime.time();
	
	int endQuote=logLine.find('\"');
	TQString message=logLine.left(endQuote);
	logLine=logLine.remove(0, endQuote+2);
	
	spacePos=logLine.find(' ');
	TQString httpResponse=ParsingHelper::parseHTTPResponse(logLine.left(spacePos));
	logLine=logLine.remove(0, spacePos+1);

	spacePos=logLine.find(' ');
	TQString bytesSent=ParsingHelper::parseSize(logLine.left(spacePos));
	logLine=logLine.remove(0, spacePos+2);
	
	TQString url;
	
	endQuote=logLine.find('\"');
	if (endQuote!=-1) {
		url=logLine.left(endQuote);
		logLine=logLine.remove(0, endQuote+3);
	}
		
	TQString agent;
	
	//TODO Convert this value to find a more simple name for the Agent
	endQuote=logLine.find('\"');
	if (endQuote!=-1) {
		agent=ParsingHelper::parseAgent(logLine.left(endQuote));
	}
	
	TQStringList list;
	list.push_back(hostName);
	list.push_back(identd);
	list.push_back(userName);
	list.push_back(httpResponse);
	list.push_back(bytesSent);
	list.push_back(agent);
	list.push_back(message);
	list.push_back(url);
	

	TQString filePath=logFile->url.path();
	LogLine* line=new LogLine(date, time, list, filePath, Globals::informationLogLevel, Globals::apacheAccessMode->id);
	return(line);
}



#include "apacheAccessReader.moc"
