/***************************************************************************
 *   Copyright (C) 2005 by Will Entriken                                   *
 *   william.entriken@villanova.edu                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef PROCESSCONTROLLER_H
#define PROCESSCONTROLLER_H

#include <tqprocess.h>
#include <tqstring.h>
#include <tqtimer.h>
#include <tqobject.h>
#include <kdeversion.h>
#if KDE_IS_VERSION(3,3,90)
#include <dnssd/remoteservice.h>
#endif

class ProcessListViewItem;

class ProcessController : public TQObject
{
	Q_OBJECT
  TQ_OBJECT
public:
	ProcessController(ProcessListViewItem * parent);
	~ProcessController();
	
	bool getStatus();
	bool getAutomatic();
	void setAutomatic(bool a);
#if KDE_IS_VERSION(3,3,90)
	DNSSD::RemoteService::Ptr getService();
	void setService(DNSSD::RemoteService::Ptr service);
#endif
	void setUrl(TQString Url);
	void setDescription(TQString Description);
	TQString getUrl();
	TQString getDescription();
	void startRip(TQString destination, TQString time);
	void stopRip();

protected slots:
	void readStdout();
	
private:
	ProcessListViewItem * myParent;
	bool myStatus;
	bool myAutomatic;
#if KDE_IS_VERSION(3,3,90)
	DNSSD::RemoteService::Ptr myService;
#endif	
	TQProcess * myProcess;
	TQString myUrl;
	TQString myDescription;
};

#endif
