/***************************************************************************
                          sq_iconlistitem.h  -  description
                             -------------------
    begin                : ??? ??? 19 2004
    copyright            : (C) 2004 by Baryshev Dmitry
    email                : ksquirrel.iv@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SQ_ICONLISTITEM_H
#define SQ_ICONLISTITEM_H

#include <tqlistbox.h>

class TQListBox;
class TQPainter;
class TQPixmap;

/* 
 *  SQ_IconListItem represents a listbox item.
 *
 *  With SQ_IconListBox it is used in SQ_Options.
 *
 *  Taken from kdelibs.
 */

class SQ_IconListItem : public TQListBoxItem
{
    public:
        SQ_IconListItem(TQListBox *listbox, const TQPixmap &pixmap, const TQString &text);

        virtual int height(const TQListBox *lb) const;
        virtual int width(const TQListBox *lb) const;
        int expandMinimumWidth(int width);

    protected:
        const TQPixmap& defaultPixmap();
        void paint(TQPainter *painter);

    private:
        TQPixmap mPixmap;
        int mMinimumWidth;
};

#endif
