/***************************************************************************
                          sq_dragprovider.cpp  -  description
                             -------------------
    begin                : ??? Sep 17 2007
    copyright            : (C) 2007 by Baryshev Dmitry
    email                : ksquirrel.iv@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <tqwidget.h>
#include <tqdragobject.h>
#include <tqpainter.h>
#include <tqpixmap.h>
#include <tqfontmetrics.h>
#include <tqtooltip.h>
#include <tqvaluevector.h>
#include <tqsize.h>

#include <kstringhandler.h>
#include <kurldrag.h>
#include <klocale.h>
#include <kurl.h>

#include <algorithm>

#include "sq_dragprovider.h"
#include "sq_iconloader.h"
#include "sq_filethumbviewitem.h"
#include "sq_thumbnailsize.h"

#define SQ_THUMB_SIZE 96

SQ_DragProvider * SQ_DragProvider::m_inst = 0;

SQ_DragProvider::SQ_DragProvider(TQObject *parent) : TQObject(parent), source(0)
{
    m_inst = this;
}

SQ_DragProvider::~SQ_DragProvider()
{}

void SQ_DragProvider::setParams(TQWidget *_source, const KFileItemList &_files, SourceType tp)
{
    source = _source;
    files = _files;
    type = tp;
}

void SQ_DragProvider::start()
{
    if(!source)
        return;

    int count = files.count();

    if(!count)
        return;

    KURL::List urls;
    KFileItem *fi;
    SQ_FileThumbViewItem *kfi;
    TQStringList names;
    int capas = type == Thumbnails ? 2 : 10; // 2 thumbnails or 10 file names
    int _capas = capas;
    TQValueVector<TQPixmap> pixmaps;
    TQPixmap *pix;
    int pixw = 0, pixh = 0;
    const int margin = 2;

    KFileItem *first = files.first();

    KFileItemListIterator it(files);

    while((fi = it.current()))
    {
        urls.append(fi->url());

        if(_capas)
        {
            if(type == Thumbnails)
            {
                kfi = reinterpret_cast<SQ_FileThumbViewItem *>(fi->extraData(source));

                if(kfi && (pix = kfi->pixmap()))
                {
                    pixmaps.append(*pix);

                    if(!pixw || !pixh)
                    {
                        pixw = pix->width();
                        pixh = pix->height();

                        if(pixw > SQ_THUMB_SIZE)
                        {
                            TQSize sz(pixw, pixh);
                            sz.scale(SQ_THUMB_SIZE, SQ_THUMB_SIZE, TQSize::ScaleMin);
                            pixw = sz.width();
                            pixh = sz.height();
                        }
                    }
                }
            }
            else
                names.append(KStringHandler::csqueeze(fi->name()));

            --_capas;
        }

        ++it;
    }

    TQDragObject *drag = new KURLDrag(urls, source);
    TQPixmap dragIcon;

    if(urls.count() > 1)
        dragIcon = SQ_IconLoader::instance()->loadIcon("kmultiple", KIcon::Desktop, KIcon::SizeSmall);
    else
        dragIcon = first->pixmap(KIcon::SizeSmall);

    const int flags = TQt::AlignAuto|TQt::AlignVCenter|TQt::ShowPrefix;
    TQPixmap dragPixmap;
    TQString text;

    // construct text
    if(type == Icons)
    {
        TQStringList::iterator sEnd = names.end();
        for(TQStringList::iterator sit = names.begin();sit != sEnd;++sit)
            text = text + *sit + '\n';
    }

    text += TQString::fromLatin1("%1 %2").arg(i18n("Total")).arg(i18n("1 file", "%n files", count));

    TQFontMetrics ms(source->font());
    TQRect r = ms.boundingRect(0, 0, 1, 1, flags, text);

    // resize pixmap
    if(type == Icons)
        dragPixmap.resize(r.width(), r.height());
    else
        dragPixmap.resize(std::max(r.width(), pixw)+margin*2, r.height()+margin+(pixh+margin)*pixmaps.count());

    TQPalette pal = TQToolTip::palette();
    TQPainter p;
    p.begin(&dragPixmap);

    // draw frame
    p.setPen(TQPen(pal.color(TQPalette::Active, TQColorGroup::Text)));
    p.setBrush(TQBrush(pal.color(TQPalette::Active, TQColorGroup::Background)));
    p.drawRect(dragPixmap.rect());

    // draw file names
    if(type == Icons)
        p.drawText(dragPixmap.rect(), flags, text);
    else // or thumbnails
    {
        int y = margin;
        TQValueVector<TQPixmap>::iterator itEnd = pixmaps.end();

        for(TQValueVector<TQPixmap>::iterator it = pixmaps.begin();it != itEnd;++it)
        {
            p.drawPixmap(TQRect((dragPixmap.width()-pixw)/2, y, pixw, pixh), *it);
            y = y + pixh + margin;
        }

        p.drawText(0, y, dragPixmap.width(), dragPixmap.height()-y, flags, text);
    }

    p.end();

    // finally, setup drag object
    drag->setPixmap(dragPixmap, TQPoint(16, -16));
    drag->dragCopy();
}
