/***************************************************************************
                          sq_config.h  -  description
                             -------------------
    begin                : ??? ??? 14 2004
    copyright            : (C) 2004 by Baryshev Dmitry
    email                : ksquirrel.iv@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SQ_CONFIG_H
#define SQ_CONFIG_H

#include <tqobject.h>
#include <kconfig.h>

class KConfig;

/*
 *  Class for reading/writing config file
 */

class SQ_Config : public TQObject
{
    public: 
        SQ_Config(TQObject *parent = 0);
        ~SQ_Config();

        static SQ_Config* instance() { return m_instance; }

        void sync();

        void setGroup(const TQString &group);
        bool hasGroup(const TQString &group) const;
        bool deleteGroup( const TQString& group, bool bDeep = true, bool bGlobal = false );
        TQString readEntry(const TQString& pKey,  const TQString& aDefault = TQString() ) const;
        TQStringList readListEntry( const TQString& pKey, char sep = ',' ) const;
        int readNumEntry( const TQString& pKey, int nDefault = 0 ) const;
        bool readBoolEntry( const TQString& pKey, bool bDefault = false ) const;
        TQRect readRectEntry( const TQString& pKey, const TQRect* pDefault = 0L ) const;
        TQPoint readPointEntry( const TQString& pKey, const TQPoint* pDefault = 0L ) const;
        TQSize readSizeEntry( const TQString& pKey, const TQSize* pDefault = 0L ) const;
        double readDoubleNumEntry( const TQString& pKey, double nDefault = 0.0 ) const;
        TQValueList<int> readIntListEntry( const TQString& pKey ) const;

        void writeEntry( const TQString& pKey, const TQString& pValue, bool bPersistent = true, bool bGlobal = false, bool bNLS = false );
        void writeEntry( const TQString& pKey, const TQStringList &rValue, char sep = ',', bool bPersistent = true, bool bGlobal = false, bool bNLS = false );
        void writeEntry( const TQString& pKey, int nValue, bool bPersistent = true, bool bGlobal = false,  bool bNLS = false );
        void writeEntry( const TQString& pKey, bool bValue, bool bPersistent = true, bool bGlobal = false, bool bNLS = false );
        void writeEntry( const TQString& pKey, const TQRect& rValue, bool bPersistent = true, bool bGlobal = false, bool bNLS = false );
        void writeEntry( const TQString& pKey, const TQPoint& rValue, bool bPersistent = true, bool bGlobal = false, bool bNLS = false );
        void writeEntry( const TQString& pKey, const TQSize& rValue, bool bPersistent = true, bool bGlobal = false, bool bNLS = false );
        void writeEntry( const TQString& pKey, double nValue, bool bPersistent = true, bool bGlobal = false, char format = 'g', int precision = 6, bool bNLS = false );
        void writeEntry( const TQString& pKey, const TQValueList<int>& rValue, bool bPersistent = true, bool bGlobal = false, bool bNLS = false );

    private:
        KConfig *kconf;
        static SQ_Config *m_instance;
};

inline
void SQ_Config::sync() { kconf->sync(); }

inline
void SQ_Config::setGroup(const TQString &group) { kconf->setGroup(group) ; }

inline
bool SQ_Config::hasGroup(const TQString &group) const { return kconf->hasGroup(group) ; }

inline
bool SQ_Config::deleteGroup(const TQString& group, bool bDeep, bool bGlobal) { return kconf->deleteGroup(group, bDeep, bGlobal) ; }

inline
TQString SQ_Config::readEntry(const TQString& pKey,  const TQString& aDefault) const { return kconf->readEntry(pKey,  aDefault) ; }

inline
TQStringList SQ_Config::readListEntry(const TQString& pKey, char sep) const { return kconf->readListEntry(pKey, sep) ; }

inline
int SQ_Config::readNumEntry(const TQString& pKey, int nDefault) const { return kconf->readNumEntry(pKey, nDefault) ; }

inline
bool SQ_Config::readBoolEntry(const TQString& pKey, bool bDefault) const { return kconf->readBoolEntry(pKey, bDefault ) ; }

inline
TQRect SQ_Config::readRectEntry(const TQString& pKey, const TQRect* pDefault) const { return kconf->readRectEntry(pKey, pDefault) ; }

inline
TQPoint SQ_Config::readPointEntry(const TQString& pKey, const TQPoint* pDefault) const { return kconf->readPointEntry(pKey, pDefault) ; }

inline
TQSize SQ_Config::readSizeEntry(const TQString& pKey, const TQSize* pDefault) const { return kconf->readSizeEntry(pKey, pDefault) ; }

inline
double SQ_Config::readDoubleNumEntry(const TQString& pKey, double nDefault) const { return kconf->readDoubleNumEntry(pKey, nDefault); }

inline
TQValueList<int> SQ_Config::readIntListEntry( const TQString& pKey ) const { return kconf->readIntListEntry(pKey); }

/**********************************************/

inline
void SQ_Config::writeEntry(const TQString& pKey, const TQString& pValue, bool bPersistent, bool bGlobal, bool bNLS) { kconf->writeEntry( pKey, pValue, bPersistent, bGlobal, bNLS ) ; }

inline
void SQ_Config::writeEntry(const TQString& pKey, const TQStringList &rValue, char sep, bool bPersistent, bool bGlobal, bool bNLS ) { kconf->writeEntry(pKey, rValue, sep, bPersistent, bGlobal, bNLS ) ; }

inline
void SQ_Config::writeEntry(const TQString& pKey, int nValue, bool bPersistent, bool bGlobal,  bool bNLS ) { kconf->writeEntry(pKey, nValue, bPersistent, bGlobal, bNLS ) ; }

inline
void SQ_Config::writeEntry(const TQString& pKey, bool bValue, bool bPersistent, bool bGlobal, bool bNLS ) { kconf->writeEntry(pKey, bValue, bPersistent, bGlobal, bNLS ) ; }

inline
void SQ_Config::writeEntry(const TQString& pKey, const TQRect& rValue, bool bPersistent, bool bGlobal, bool bNLS ) { kconf->writeEntry(pKey, rValue, bPersistent, bGlobal, bNLS ) ; }

inline
void SQ_Config::writeEntry(const TQString& pKey, const TQPoint& rValue, bool bPersistent, bool bGlobal, bool bNLS ) { kconf->writeEntry(pKey, rValue, bPersistent, bGlobal, bNLS ) ; }

inline
void SQ_Config::writeEntry(const TQString& pKey, const TQSize& rValue, bool bPersistent, bool bGlobal, bool bNLS ) { kconf->writeEntry(pKey,rValue, bPersistent, bGlobal, bNLS ) ; }

inline
void SQ_Config::writeEntry( const TQString& pKey, double nValue, bool bPersistent, bool bGlobal, char format, int precision, bool bNLS) { kconf->writeEntry(pKey, nValue, bPersistent, bGlobal, format, precision, bNLS); }

inline
void SQ_Config::writeEntry( const TQString& pKey, const TQValueList<int>& rValue, bool bPersistent, bool bGlobal, bool bNLS) { kconf->writeEntry(pKey, rValue, bPersistent, bGlobal, bNLS); }

#endif
