/***************************************************************************
 *   Copyright Sean Meiners 2004 <Sean.Meiners@LinspireInc.com>            *
 *   Copyright (C) by                                                      *
 *     - 2005: Christian Leh <moodwrod@web.de>                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License (version 2) as   *
 *   published by the Free Software Foundation. (The original KSplash/ML   *
 *   codebase (upto version 0.95.3) is BSD-licensed.)                      *
 *                                                                         *
 ***************************************************************************/

#ifndef FADEWIDGET_H
#define FADEWIDGET_H

#include <tqwidget.h>
#include <tqptrlist.h>
#include <tqpixmap.h>
#include <tqimage.h>

#include <kimageeffect.h>

class TQTimer;

class EffectWidget : public TQWidget
{
  Q_OBJECT
  TQ_OBJECT

 public:
  EffectWidget(TQWidget *parent = 0,const char *name = 0);

  static void setBackgroundImage(TQImage *image) { bgImage = image; }

  void setImage(TQImage *i);
  void setDelay(int delayInMS);
  void setLoop(bool loop);
  void setSteps(int steps);
  void setStart(float begin, float end = 1.0, bool reverse = false);

  void start();
  void stop();
  void rewind();

  void paintEvent(TQPaintEvent *);
  void resizeEvent(TQResizeEvent *);
  void moveEvent(TQMoveEvent *);

  void updateCache();

 public slots:
  void timerTick();

 private:
  static TQImage *bgImage;

  TQTimer *timer;
  TQImage *image;
  TQImage background;
  unsigned int delayMS;
  unsigned int currentStep;
  unsigned int totalSteps;
  bool playing;
  bool loop;
  float
    beginOpacity,
    endOpacity;
};

#endif
