/***************************************************************************
                          permission.h  -  description
                             -------------------
    begin                : Sun Jan 13 2002
    copyright            : (C) 2002 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PERMISSION_H
#define PERMISSION_H

/*
 * This two includes are required, because you have to use
 * krenames internal structures and enums.
 */
#include "batchrenamer.h"
#include "pluginloader.h"
#include "plugin.h"
#include "helpdialog.h"

#include <stdio.h>

class KComboBox;
class TQCheckBox;
class TQGroupBox;
class TQVBoxLayout;
class TQHBoxLayout;
class TQString;
class TQWidget;


// Plugin class starts here
class MyPermPlugin: public Plugin {
    Q_OBJECT
  TQ_OBJECT
    public:
        const TQString getName() const;
        const TQString getAccelName() const;
        const int type() const;

        bool checkError();
        void drawInterface( TQWidget* w, TQVBoxLayout* l );
        void fillStructure();
        TQString processFile( BatchRenamer* b, int, TQString token, int );
        void finished();
        const TQPixmap getIcon() const;        

    private:
        int getPermissions();
        int getGid( TQString group );
        int getUid( TQString owner );

        struct pervals {
            bool changePermissions;
            bool changeOwner;

            TQString owner;  // name of owner
            TQString group;  // name of group

            int newPermission;  // Permissions
        }perm;

    private slots:
        void enableControls();

    protected:
        TQGroupBox* groupPermission;
        TQGroupBox* groupOwner;
        TQCheckBox* checkPermissions;
        TQCheckBox* checkOwner;
        TQCheckBox* permBox[3][4];
        KComboBox* username;
        KComboBox* groupname;

        TQVBoxLayout* groupOwnerLayout;
        TQVBoxLayout* Layout0;
        TQHBoxLayout* Layout2;
        TQHBoxLayout* Layout3;
        TQHBoxLayout* Layout4;
};

#endif
