/***************************************************************************
                          mydirplugin.h  -  description
                             -------------------
    begin                : Tue Jan 29 2002
    copyright            : (C) 2002 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MYDIRPLUGIN_H
#define MYDIRPLUGIN_H

#include "batchrenamer.h"
#include "pluginloader.h"
#include "plugin.h"
#include "helpdialog.h"

class TQDir;
class TQHBoxLayout;
class TQGroupBox;
class TQLineEdit;
class TQPushButton;
class TQSpinBox;
class TQString;
class TQVBoxLayout;
class TQWidget;
class MyDirPlugin : public Plugin  {
    Q_OBJECT
  TQ_OBJECT
    public:
        const TQString getName() const;
        const TQString getAccelName() const;
        const int type() const;
        bool checkError();
        void drawInterface( TQWidget* w, TQVBoxLayout* l );
        void fillStructure();
        TQString processFile( BatchRenamer*, int, TQString token, int );
        void finished();

        const TQPixmap getIcon() const;
        
    private slots:
        void chooseDir();

    protected:
        int fpd; // files per dir
        int filecounter;
        int dircounter;
        TQString dir;
        TQString curdir;
        TQDir* d;

        TQLineEdit* outputdir;
        TQPushButton* buttonDir;
        TQSpinBox* spinFiles;
        TQSpinBox* spinStart;

        TQGroupBox* groupOutput;
        TQHBoxLayout* groupOutputLayout;

        TQGroupBox* groupNumber;
        TQHBoxLayout* groupNumberLayout;
};

#endif
