/***************************************************************************
                          mydirplugin.cpp  -  description
                             -------------------
    begin                : Tue Jan 29 2002
    copyright            : (C) 2002 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// Own includes
#include "mydirplugin.h"

// KDE includes
#include <kapplication.h>
#include <kiconloader.h>
#include <kfiledialog.h>
#include <klocale.h>

// QT includes
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqlineedit.h>
#include <tqpushbutton.h>
#include <tqgroupbox.h>
#include <tqspinbox.h>

const TQString MyDirPlugin::getName() const
{
    return i18n("Dir Plugin");
}

const TQString MyDirPlugin::getAccelName() const
{
    return i18n("&Dir Plugin");
}

const int MyDirPlugin::type() const
{
    return TYPE_FINAL_FILE;
}

bool MyDirPlugin::checkError()
{
    return true;
}

const TQPixmap MyDirPlugin::getIcon() const
{
    return kapp->iconLoader()->loadIcon( "folder", KIcon::Small );
}

void MyDirPlugin::drawInterface( TQWidget* w, TQVBoxLayout* l )
{
    TQSpacerItem* spacer = new TQSpacerItem( 20, 20, TQSizePolicy::Expanding, TQSizePolicy::Minimum );
    TQSpacerItem* spacer2 = new TQSpacerItem( 20, 20, TQSizePolicy::Minimum, TQSizePolicy::Expanding );

    TQVBoxLayout* LayoutA = new TQVBoxLayout( 0, 6, 6 );
    TQVBoxLayout* LayoutB = new TQVBoxLayout( 0, 6, 6 );

    m_widget = w;

    TQLabel* la = new TQLabel( w );
    la->setText( i18n("<qt>This plugin sorts files after renaming in subdirectories.</qt>") );
    l->addWidget( la );

    groupNumber = new TQGroupBox( w );
    groupNumber->setTitle( i18n( "&Options" ) );
    groupNumber->setColumnLayout(0, Qt::Vertical );
    groupNumber->layout()->setSpacing( 6 );
    groupNumber->layout()->setMargin( 11 );
    groupNumberLayout = new TQHBoxLayout( groupNumber->layout() );
    groupNumberLayout->setAlignment( TQt::AlignTop );

    TQLabel* la2 = new TQLabel( groupNumber );
    la2->setText( i18n( "Files per directory:" ) );

    spinFiles = new TQSpinBox( groupNumber );
    spinFiles->setRange( 1, 60000 );
    spinFiles->setValue( 10 );

    TQLabel* la3 = new TQLabel( groupNumber );
    la3->setText( i18n( "Start index:" ) );

    spinStart = new TQSpinBox( groupNumber );
    spinFiles->setRange( 0, 60000 );

    LayoutA->addWidget( la2 );
    LayoutA->addWidget( la3 );
    LayoutB->addWidget( spinFiles );
    LayoutB->addWidget( spinStart );

    groupNumberLayout->addLayout( LayoutA );
    groupNumberLayout->addLayout( LayoutB );
    groupNumberLayout->addItem( spacer );

    groupOutput = new TQGroupBox( w );
    groupOutput->setTitle( i18n( "Output &Directory" ) );
    groupOutput->setColumnLayout(0, Qt::Vertical );
    groupOutput->layout()->setSpacing( 6 );
    groupOutput->layout()->setMargin( 11 );
    groupOutputLayout = new TQHBoxLayout( groupOutput->layout() );
    groupOutputLayout->setAlignment( TQt::AlignTop );

    outputdir = new TQLineEdit( groupOutput );
    buttonDir = new TQPushButton( groupOutput );
    buttonDir->setText( "..." );

    groupOutputLayout->addWidget( outputdir );
    groupOutputLayout->addWidget( buttonDir );

    l->addWidget( groupNumber );
    l->addWidget( groupOutput );
    l->addItem( spacer2 );

    connect( buttonDir, TQT_SIGNAL(clicked()), this, TQT_SLOT(chooseDir()));
}

void MyDirPlugin::fillStructure()
{
    fpd = spinFiles->value();
    fpd--;
    dir = outputdir->text();

    filecounter = 0;
    dircounter = spinStart->value();
    curdir = dir +  TQString("/%1/").arg( dircounter );

    d = new TQDir( dir );
    d->mkdir( curdir );
}

TQString MyDirPlugin::processFile( BatchRenamer*, int, TQString token, int )
{
    TQString newname;
    // token = filename
    if( filecounter == fpd ) {
        filecounter = 0;
        dircounter++;
        curdir = dir +  TQString("/%1/").arg( dircounter );
        d->mkdir( curdir );
    }

    TQFileInfo f( token );
    newname = curdir + f.fileName();
    d->rename( token, newname );
    filecounter++;
    return TQString();
}

void MyDirPlugin::finished()
{
    filecounter = dircounter = 0;
}

void MyDirPlugin::chooseDir()
{
    TQString s (KFileDialog::getExistingDirectory ( TQString() ));
    if(!s.isEmpty())
        outputdir->setText( s );
}

