/***************************************************************************
                          guimodeselector.cpp  -  description
                             -------------------
    begin                : Fre Jun 6 2003
    copyright            : (C) 2003 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "guimodeselector.h"

// TQt includes
#include <tqbuttongroup.h>
#include <tqframe.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqradiobutton.h>

// KDE includes
#include <klocale.h>

GUIModeSelector::GUIModeSelector()
{
    optionWizard = optionTabs = 0;
}

GUIModeSelector::~GUIModeSelector()
{
}

bool GUIModeSelector::useWizard() const
{
    return optionWizard->isChecked();
}

void GUIModeSelector::setUseWizard( bool b )
{
    optionWizard->setChecked( b );
    optionTabs->setChecked( !b );
}

const TQString GUIModeSelector::guiModeCaption() const
{
    return i18n("Look and Feel");
}

void GUIModeSelector::createFrame( TQFrame* frame )
{
    TQVBoxLayout* layout = new TQVBoxLayout( frame );
    TQSpacerItem* spacer = new TQSpacerItem( 20, 20, TQSizePolicy::Minimum, TQSizePolicy::Expanding );

    TQButtonGroup* group = new TQButtonGroup( frame );
    group->setColumnLayout(0, Qt::Vertical );
    TQVBoxLayout* lgroup = new TQVBoxLayout( group->layout() );

    optionWizard = new TQRadioButton( group );
    optionWizard->setText( i18n("Use &wizard style GUI (beginners)") );
    optionTabs = new TQRadioButton( group );
    optionTabs->setText( i18n("Use &tabbed GUI (advanced users)") );

    lgroup->addWidget( new TQLabel( i18n("Configure the look and feel of the KRename GUI:<br>"), group ) );
    lgroup->addWidget( optionWizard );
    lgroup->addWidget( optionTabs );
    lgroup->addItem( spacer );

    layout->addWidget( group );
    layout->addItem( spacer );   
}


