/***************************************************************************
                          kradioapp.h  -  description
                             -------------------
    begin                : Sa Feb  9 2002
    copyright            : (C) 2002 by Klas Kalass / Martin Witte / Frank Schwanz
    email                : klas.kalass@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KRADIO_KRADIOAPP_H
#define KRADIO_KRADIOAPP_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <tqdict.h>

#include <kapplication.h>
#include <kaboutapplication.h>
#include "pluginmanager.h"
#include "plugins.h"

class KLibrary;

class KRadioAbout : public PluginBase
{
public:
    KRadioAbout(const TQString &name) : PluginBase(name, "KRadio Application") {}

    virtual TQString pluginClassName() const { return "KRadioAbout"; }

    virtual ConfigPageInfo createConfigurationPage () { return ConfigPageInfo(); }
    virtual AboutPageInfo  createAboutPage ();

    virtual void   saveState    (KConfig *) const {}
    virtual void   restoreState (KConfig *)       {}
};




typedef  PluginBase     *(*t_kradio_plugin_init_func)(const TQString & cls, const TQString &obj);
typedef  void            (*t_kradio_plugin_info_func)(TQMap<TQString, TQString> &);
typedef  void            (*t_kradio_plugin_libload_func)();
typedef  void            (*t_kradio_plugin_libunload_func)();


struct PluginLibraryInfo {
    KLibrary                      *library;
    TQMap<TQString,TQString>          plugins;
    t_kradio_plugin_init_func      init_func;
    t_kradio_plugin_info_func      info_func;
    t_kradio_plugin_libload_func   libload_func;
    t_kradio_plugin_libunload_func libunload_func;

    PluginLibraryInfo() : library(NULL), init_func(NULL), info_func(NULL), libload_func(NULL), libunload_func(NULL) {}
    PluginLibraryInfo(const TQString &libname);
    bool valid() { return init_func && info_func && library && libload_func && libunload_func; }
};


struct PluginClassInfo {
    TQString                    class_name;
    TQString                    description;
    t_kradio_plugin_init_func  create_function;

    PluginClassInfo() : create_function(NULL) {}
    PluginClassInfo(const TQString &_name, const TQString &descr, t_kradio_plugin_init_func init_func)
        : class_name(_name), description(descr), create_function(init_func) {}
    PluginBase *CreateInstance(const TQString &obj_name) { return create_function ? create_function(class_name, obj_name) : NULL; }
};


class KRadioApp : public KApplication
{
Q_OBJECT
  TQ_OBJECT
public:
    KRadioApp();
    virtual ~KRadioApp();

    virtual void             saveState    (KConfig *c);
    virtual void             restoreState (KConfig *c);

    virtual PluginManager   *createNewInstance(const TQString &name);

    virtual KLibrary   *LoadLibrary (const TQString &library);
    virtual void        UnloadLibrary (const TQString &library);
    virtual PluginBase *CreatePlugin (PluginManager *manager, const TQString &name, const TQString &object_name);

    virtual const TQMap<TQString, PluginLibraryInfo> &getPluginLibraries() const { return m_PluginLibraries; }
    virtual const TQMap<TQString, PluginClassInfo>   &getPluginClasses()   const { return m_PluginInfos; }

    virtual void  startPlugins();

protected slots:

    virtual void  saveState();
    virtual void  slotAboutToQuit();

protected:

    TQDict<PluginManager>        m_Instances;

    TQMap<TQString, PluginLibraryInfo>  m_PluginLibraries;
    TQMap<TQString, PluginClassInfo>    m_PluginInfos;

    bool                              m_quitting;
};


#endif
