/***************************************************************************
                          aboutwidget.cpp  -  description
                             -------------------
    begin                : Sa Sep 13 2003
    copyright            : (C) 2003 by Martin Witte
    email                : witte@kawo1.rwth-aachen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/* Unfortunately KDE doesn't provide the class KAboutContainerBase
   to public programming, so we have to copy most of that code into
   an own class :(
*/

#include "include/kradioversion.h"
#include "include/aboutwidget.h"
#include <tqframe.h>
#include <kaboutdialog.h>
#include <tqtabwidget.h>
#include <tqlayout.h>
#include <tqtabbar.h>
#include <tqimage.h>

#include <kglobalsettings.h>
#include <ktextbrowser.h>
#include <tqtextedit.h>
#include <kdebug.h>
#include <kapplication.h>
#include <klocale.h>
#include <kaboutdata.h>
#include <kurllabel.h>

// copied (and renamed) from kaboutdialog.cpp
// original: KAboutTabWidget

class KRadioAboutTabWidget : public TQTabWidget
{
public:
    KRadioAboutTabWidget( TQWidget* parent ) : TQTabWidget( parent ) {}
    TQSize sizeHint() const {
    return TQTabWidget::sizeHint().expandedTo( tabBar()->sizeHint() + TQSize(4,4) );
    }
};


// copied (renamed and extended) from kaboutdialog.cpp
// original: KAboutContainerBase

KRadioAboutWidget::KRadioAboutWidget(const KAboutData &aboutData, int layoutType, TQWidget *_parent,
                      char *_name )
  : TQWidget( _parent, _name ),
    mImageLabel(0), mTitleLabel(0), mIconLabel(0),mVersionLabel(0),
    mAuthorLabel(0), mImageFrame(0),mPageTab(0),mPlainSpace(0)
{
  mTopLayout = new TQVBoxLayout( this, 0, KDialog::spacingHint() );
  if( mTopLayout == 0 ) { return; }

  if( layoutType & AbtImageOnly )
  {
    layoutType &= ~(AbtImageLeft|AbtImageRight|AbtTabbed|AbtPlain);
  }
  if( layoutType & AbtImageLeft )
  {
    layoutType &= ~AbtImageRight;
  }

  if( layoutType & AbtTitle )
  {
    mTitleLabel = new TQLabel( this, "title" );
    mTitleLabel->setAlignment(AlignCenter);
    mTopLayout->addWidget( mTitleLabel );
    mTopLayout->addSpacing( KDialog::spacingHint() );
  }

  if( layoutType & AbtProduct )
  {
    TQWidget *productArea = new  TQWidget( this, "area" );
    mTopLayout->addWidget( productArea, 0, AlignLeft );

    TQHBoxLayout *hbox = new TQHBoxLayout(productArea,0,KDialog::spacingHint());
    if( hbox == 0 ) { return; }

    mIconLabel = new TQLabel( productArea );
    hbox->addWidget( mIconLabel, 0, AlignLeft|AlignHCenter );

    TQVBoxLayout *vbox = new TQVBoxLayout();
    if( vbox == 0 ) { return; }
    hbox->addLayout( vbox );

    mVersionLabel = new TQLabel( productArea, "version" );
    mAuthorLabel  = new TQLabel( productArea, "author" );
    vbox->addWidget( mVersionLabel );
    vbox->addWidget( mAuthorLabel );
    hbox->activate();

    mTopLayout->addSpacing( KDialog::spacingHint() );
  }

  TQHBoxLayout *hbox = new TQHBoxLayout();
  if( hbox == 0 ) { return; }
  mTopLayout->addLayout( hbox, 10 );

  if( layoutType & AbtImageLeft )
  {
    TQVBoxLayout *vbox = new TQVBoxLayout();
    hbox->addLayout(vbox);
    vbox->addSpacing(1);
    mImageFrame = new TQFrame( this );
    setImageFrame( true );
    vbox->addWidget( mImageFrame );
    vbox->addSpacing(1);

    vbox = new TQVBoxLayout( mImageFrame, 1 );
    mImageLabel = new KRadioImageTrackLabel( mImageFrame );
    connect( mImageLabel, TQT_SIGNAL(mouseTrack( int, const TQMouseEvent * )),
         TQT_SLOT( slotMouseTrack( int, const TQMouseEvent * )) );
    vbox->addStretch(10);
    vbox->addWidget( mImageLabel );
    vbox->addStretch(10);
    vbox->activate();
  }

  if( layoutType & AbtTabbed )
  {
    mPageTab = new KRadioAboutTabWidget( this );
    if( mPageTab == 0 ) { return; }
    hbox->addWidget( mPageTab, 10 );
  }
  else if( layoutType & AbtImageOnly )
  {
    mImageFrame = new TQFrame( this );
    setImageFrame( true );
    hbox->addWidget( mImageFrame, 10 );

    TQGridLayout *gbox = new TQGridLayout(mImageFrame, 3, 3, 1, 0 );
    gbox->setRowStretch( 0, 10 );
    gbox->setRowStretch( 2, 10 );
    gbox->setColStretch( 0, 10 );
    gbox->setColStretch( 2, 10 );

    mImageLabel = new KRadioImageTrackLabel( mImageFrame );
    connect( mImageLabel, TQT_SIGNAL(mouseTrack( int, const TQMouseEvent * )),
         TQT_SLOT( slotMouseTrack( int, const TQMouseEvent * )) );
    gbox->addWidget( mImageLabel, 1, 1 );
    gbox->activate();
  }
  else
  {
    mPlainSpace = new TQFrame( this );
    if( mPlainSpace == 0 ) { return; }
    hbox->addWidget( mPlainSpace, 10 );
  }

  if( layoutType & AbtImageRight )
  {
    TQVBoxLayout *vbox = new TQVBoxLayout();
    hbox->addLayout(vbox);
    vbox->addSpacing(1);
    mImageFrame = new TQFrame( this );
    setImageFrame( true );
    vbox->addWidget( mImageFrame );
    vbox->addSpacing(1);

    vbox = new TQVBoxLayout( mImageFrame, 1 );
    mImageLabel = new KRadioImageTrackLabel( mImageFrame );
    connect( mImageLabel, TQT_SIGNAL(mouseTrack( int, const TQMouseEvent * )),
         TQT_SLOT( slotMouseTrack( int, const TQMouseEvent * )) );
    vbox->addStretch(10);
    vbox->addWidget( mImageLabel );
    vbox->addStretch(10);
    vbox->activate();
  }

  fontChange( font() );

  setAboutData(aboutData);
}


void KRadioAboutWidget::show( void )
{
    TQWidget::show();
}

TQSize KRadioAboutWidget::sizeHint( void ) const
{
    return minimumSize().expandedTo( TQSize( TQWidget::sizeHint().width(), 0 ) );
}

void KRadioAboutWidget::fontChange( const TQFont &/*oldFont*/ )
{
  if( mTitleLabel != 0 )
  {
    TQFont f( KGlobalSettings::generalFont() );
    f.setBold( true );
    f.setPointSize( 14 ); // Perhaps changeable ?
    mTitleLabel->setFont(f);
  }

  if( mVersionLabel != 0 )
  {
    TQFont f( KGlobalSettings::generalFont() );
    f.setBold( true );
    mVersionLabel->setFont(f);
    mAuthorLabel->setFont(f);
    mVersionLabel->parentWidget()->layout()->activate();
  }

  update();
}

TQFrame *KRadioAboutWidget::addTextPage( const TQString &title,
                      const TQString &text,
                      bool richText, int numLines )
{
  TQFrame *page = addEmptyPage( title );
  if( page == 0 ) { return 0; }
  if( numLines <= 0 ) { numLines = 10; }

  TQVBoxLayout *vbox = new TQVBoxLayout( page, KDialog::spacingHint() );

  if( richText == true )
  {
    KTextBrowser *browser = new KTextBrowser( page, "browser" );
    browser->setHScrollBarMode( TQScrollView::AlwaysOff );
    browser->setText( text );
    browser->setMinimumHeight( fontMetrics().lineSpacing()*numLines );

    vbox->addWidget(browser);
    connect(browser, TQT_SIGNAL(urlClick(const TQString &)),
        TQT_SLOT(slotUrlClick(const TQString &)));
    connect(browser, TQT_SIGNAL(mailClick(const TQString &,const TQString &)),
        TQT_SLOT(slotMailClick(const TQString &,const TQString &)));
  }
  else
  {
    TQTextEdit *textEdit = new TQTextEdit( page, "text" );
    textEdit->setReadOnly( true );
    textEdit->setMinimumHeight( fontMetrics().lineSpacing()*numLines );
    textEdit->setWordWrap( TQTextEdit::NoWrap );
    vbox->addWidget( textEdit );
  }

  return page;
}

TQFrame *KRadioAboutWidget::addLicensePage( const TQString &title,
                      const TQString &text, int numLines)
{
  TQFrame *page = addEmptyPage( title );
  if( page == 0 ) { return 0; }
  if( numLines <= 0 ) { numLines = 10; }

  TQVBoxLayout *vbox = new TQVBoxLayout( page, KDialog::spacingHint() );

  TQTextEdit *textEdit = new TQTextEdit( page, "license" );
  textEdit->setFont( KGlobalSettings::fixedFont() );
  textEdit->setReadOnly( true );
  textEdit->setWordWrap( TQTextEdit::NoWrap );
  textEdit->setText( text );
  textEdit->setMinimumHeight( fontMetrics().lineSpacing()*numLines );
  vbox->addWidget( textEdit );

  return page;
}


KAboutContainer *KRadioAboutWidget::addContainerPage( const TQString &title,
                            int childAlignment,
                            int innerAlignment )
{
  if( mPageTab == 0 )
  {
    kdDebug(291) << "addPage: " << i18n("Invalid layout") << endl;
    return 0;
  }

  KAboutContainer *container = new KAboutContainer( mPageTab, "container",
    KDialog::spacingHint(), KDialog::spacingHint(), childAlignment,
                          innerAlignment );
  mPageTab->addTab( container, title );

  if( mContainerList.resize( mContainerList.size() + 1) == true )
  {
    mContainerList[ mContainerList.size()-1 ]=container;
  }

  connect(container, TQT_SIGNAL(urlClick(const TQString &)),
      TQT_SLOT(slotUrlClick(const TQString &)));
  connect(container, TQT_SIGNAL(mailClick(const TQString &,const TQString &)),
      TQT_SLOT(slotMailClick(const TQString &,const TQString &)));

  return container;
}


KAboutContainer *KRadioAboutWidget::addScrolledContainerPage(
                      const TQString &title,
                      int childAlignment,
                      int innerAlignment )
{
  if( mPageTab == 0 )
  {
    kdDebug(291) << "addPage: " << "Invalid layout" << endl;
    return 0;
  }

  TQFrame *page = addEmptyPage( title );
  TQVBoxLayout *vbox = new TQVBoxLayout( page, KDialog::spacingHint() );
  TQScrollView *scrollView = new TQScrollView( page );
  scrollView->viewport()->setBackgroundMode( PaletteBackground );
  vbox->addWidget( scrollView );

  KAboutContainer *container = new KAboutContainer( scrollView, "container",
    KDialog::spacingHint(), KDialog::spacingHint(), childAlignment,
    innerAlignment );
  scrollView->addChild( container );


  connect(container, TQT_SIGNAL(urlClick(const TQString &)),
      TQT_SLOT(slotUrlClick(const TQString &)));
  connect(container, TQT_SIGNAL(mailClick(const TQString &,const TQString &)),
      TQT_SLOT(slotMailClick(const TQString &,const TQString &)));

  return container;
}


TQFrame *KRadioAboutWidget::addEmptyPage( const TQString &title )
{
  if( mPageTab == 0 )
  {
    kdDebug(291) << "addPage: " << "Invalid layout" << endl;
    return 0;
  }

  TQFrame *page = new TQFrame( mPageTab, title.latin1() );
  page->setFrameStyle( TQFrame::NoFrame );

  mPageTab->addTab( page, title );
  return page;
}


KAboutContainer *KRadioAboutWidget::addContainer( int childAlignment,
                            int innerAlignment )
{
  KAboutContainer *container = new KAboutContainer( this, "container",
    0, KDialog::spacingHint(), childAlignment, innerAlignment );
  mTopLayout->addWidget( container, 0, childAlignment );

  if( mContainerList.resize( mContainerList.size() + 1) == true )
  {
    mContainerList[ mContainerList.size()-1 ]=container;
  }

  connect(container, TQT_SIGNAL(urlClick(const TQString &)),
      TQT_SLOT(slotUrlClick(const TQString &)));
  connect(container, TQT_SIGNAL(mailClick(const TQString &,const TQString &)),
      TQT_SLOT(slotMailClick(const TQString &,const TQString &)));

  return container;
}



void KRadioAboutWidget::setTitle( const TQString &title )
{
  if( mTitleLabel == 0 )
  {
    kdDebug(291) << "setTitle: " << "Invalid layout" << endl;
    return;
  }
  mTitleLabel->setText(title);
}


void KRadioAboutWidget::setImage( const TQString &fileName )
{
  if( mImageLabel == 0 )
  {
    kdDebug(291) << "setImage: " << "Invalid layout" << endl;
    return;
  }
  if( fileName.isNull() )
  {
    return;
  }

  TQImage logo( fileName );
  if( logo.isNull() == false )
  {
    TQPixmap pix;
    pix = logo;
    mImageLabel->setPixmap( pix );
  }
  mImageFrame->layout()->activate();

}


void KRadioAboutWidget::setImageBackgroundColor( const TQColor &color )
{
  if( mImageFrame != 0 )
  {
    mImageFrame->setBackgroundColor( color );
  }
}


void KRadioAboutWidget::setImageFrame( bool state )
{
  if( mImageFrame != 0 )
  {
    if( state == true )
    {
      mImageFrame->setFrameStyle( TQFrame::Panel | TQFrame::Sunken );
      mImageFrame->setLineWidth(1);
    }
    else
    {
      mImageFrame->setFrameStyle( TQFrame::NoFrame );
      mImageFrame->setLineWidth(0);
    }
  }
}


void KRadioAboutWidget::setProduct( const TQString &appName,
                      const TQString &/*version*/,
                      const TQString &author,
                      const TQString &year )
{
  if( mIconLabel == 0 )
  {
    kdDebug(291) << "setProduct: " << "Invalid layout" << endl;
    return;
  }

  if ( kapp )
      mIconLabel->setPixmap( kapp->icon() );

  TQString msg1 = i18n("%1 %2 (Using KDE %3)").arg(appName).
    arg(TQString::fromLatin1(KRADIO_VERSION)).
    arg(TQString::fromLatin1(KDE_VERSION_STRING));
  TQString msg2 = !year.isEmpty() ? i18n("%1 %2, %3").arg('').arg(year).
    arg(author) : TQString::fromLatin1("");

  mVersionLabel->setText( msg1 );
  mAuthorLabel->setText( msg2 );
  if( msg2.isEmpty() )
  {
    mAuthorLabel->hide();
  }

  mIconLabel->parentWidget()->layout()->activate();
}


void KRadioAboutWidget::slotMouseTrack( int mode, const TQMouseEvent *e )
{
  emit mouseTrack( mode, e );
}


void KRadioAboutWidget::slotUrlClick( const TQString &url )
{
    if ( kapp )
        kapp->invokeBrowser( url );
}


void KRadioAboutWidget::slotMailClick( const TQString &/*_name*/,
                     const TQString &_address )
{
    if ( kapp )
        kapp->invokeMailer( _address, TQString() );
}


// copied (and renamed) from kaboutapplication.cpp
// original: KAboutApplication::buildDialog

void KRadioAboutWidget::setAboutData(const KAboutData &_aboutData)
{
    const KAboutData *aboutData = &_aboutData;
    if (aboutData->programName().length()) {
        setProduct( aboutData->programName(), aboutData->version(),
                    TQString(), TQString() );
    }

    TQString appPageText = aboutData->shortDescription() + "\n";

    if (!aboutData->otherText().isEmpty())
        appPageText += "\n" + aboutData->otherText()+"\n";

    if (!aboutData->copyrightStatement().isEmpty())
        appPageText += "\n" + aboutData->copyrightStatement()+"\n";

    KAboutContainer *appPage = addContainerPage( i18n("&About"));

    TQLabel *appPageLabel = new TQLabel( appPageText, 0 );
    appPage->addWidget( appPageLabel );

    if (!aboutData->homepage().isEmpty()) {
        KURLLabel *url = new KURLLabel();
        url->setText(aboutData->homepage());
        url->setURL(aboutData->homepage());
        appPage->addWidget( url );
        // FIXME
        connect( url, TQT_SIGNAL(leftClickedURL(const TQString &)),
                 this, TQT_SLOT(slotUrlClick(const TQString &)));
    }

    int authorCount = aboutData->authors().count();

    if (authorCount) {
        TQString authorPageTitle = authorCount == 1 ?
            i18n("A&uthor") : i18n("A&uthors");
        KAboutContainer *authorPage = addScrolledContainerPage( authorPageTitle );
        TQValueList<KAboutPerson>::ConstIterator it  = aboutData->authors().begin();
        TQValueList<KAboutPerson>::ConstIterator end = aboutData->authors().end();
        for (; it != end; ++it) {
            authorPage->addPerson( (*it).name(), (*it).emailAddress(),
                                   (*it).webAddress(), (*it).task() );
        }
    }

    int creditsCount = aboutData->credits().count();

    if (creditsCount) {
        KAboutContainer *creditsPage =
            addScrolledContainerPage( i18n("&Thanks To") );
        TQValueList<KAboutPerson>::ConstIterator it  = aboutData->credits().begin();
        TQValueList<KAboutPerson>::ConstIterator end = aboutData->credits().end();
        for (; it != end; ++it) {
          creditsPage->addPerson( (*it).name(), (*it).emailAddress(),
                                  (*it).webAddress(), (*it).task() );
        }
    }

    const TQValueList<KAboutTranslator> translatorList = aboutData->translators();

    if(translatorList.count() > 0) {
        KAboutContainer *translatorPage =
            addScrolledContainerPage( i18n("T&ranslation") );

        TQValueList<KAboutTranslator>::ConstIterator it  = translatorList.begin();
        TQValueList<KAboutTranslator>::ConstIterator end = translatorList.end();
        for(; it != end; ++it) {
            translatorPage->addPerson((*it).name(), (*it).emailAddress(),
                                      0,0);
        }

        TQLabel *label = new TQLabel(KAboutData::aboutTranslationTeam(),
                                   translatorPage);
        label->adjustSize();
        label->setMinimumSize(label->sizeHint());
        translatorPage->addWidget(label);
    }

    if (!aboutData->license().isEmpty() ) {
        addLicensePage( i18n("&License Agreement"), aboutData->license() );
    }
}


//
// A class that can can monitor mouse movements on the image
//
// copied (and renamed) from kaboutdialog.cpp
// original: KImageTrackLabel

KRadioImageTrackLabel::KRadioImageTrackLabel( TQWidget *_parent, const char *_name, WFlags f )
  : TQLabel( _parent, _name, f )
{
  setText( i18n("Image missing"));
}

void KRadioImageTrackLabel::mousePressEvent( TQMouseEvent *e )
{
  emit mouseTrack( MousePress, e );
}

void KRadioImageTrackLabel::mouseReleaseEvent( TQMouseEvent *e )
{
  emit mouseTrack( MouseRelease, e );
}

void KRadioImageTrackLabel::mouseDoubleClickEvent( TQMouseEvent *e )
{
  emit mouseTrack( MouseDoubleClick, e );
}

void KRadioImageTrackLabel::mouseMoveEvent ( TQMouseEvent *e )
{
  emit mouseTrack( MouseDoubleClick, e );
}




#include "aboutwidget.moc"
