/***************************************************************************
                          radioview-configuration.h  -  description
                             -------------------
    begin                : Fr Aug 15 2003
    copyright            : (C) 2003 by Martin Witte
    email                : witte@kawo1.rwth-aachen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KRADIO_RADIOVIEW_CONFIGURATION_H
#define KRADIO_RADIOVIEW_CONFIGURATION_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif



#include <tqtabwidget.h>

class RadioViewConfiguration : public TQTabWidget
{
Q_OBJECT
  TQ_OBJECT
public :
    RadioViewConfiguration(TQWidget *parent = NULL);
    ~RadioViewConfiguration();

    void addTab    (TQWidget *child, const TQString &label);
    void addTab    (TQWidget *child, const TQIconSet &iconset, const TQString &label);
    void addTab    (TQWidget *child, TQTab *tab);
    void insertTab (TQWidget *child, const TQString &label, int index = -1);
    void insertTab (TQWidget *child, const TQIconSet &iconset, const TQString &label, int index = -1);
    void insertTab (TQWidget *child, TQTab *tab, int index = -1);
    void removePage(TQWidget *w);

public slots:

    void slotOK();
    void slotCancel();
    void slotSetDirty(); 

signals:

    void sigOK();
    void sigCancel();

protected:
    bool m_dirty;
};



#endif
