/***************************************************************************
 *   Copyright (C) 2007 by Michael Zanetti   *
 *   michael_zanetti@gmx.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/


#include "verifypopup.h"
#include "otrlchatinterface.h"
#include "otrplugin.h"

#include "tqlabel.h"

#include "klocale.h"
#include "kactivelabel.h"
#include "kcombobox.h"

#include "kopetechatsession.h"
#include "kopetecontact.h"

VerifyPopup::VerifyPopup(TQWidget* parent, const char* name, Kopete::ChatSession *session, bool modal, WFlags fl)
: VerifyPopupUI(parent,name, modal,fl)
{
	this->session = session;
	alContact->setText(i18n("Verify fingerprint for %1.").arg(OtrlChatInterface::self()->formatContact(session->members().getFirst()->contactId())));
	alFingerprint->setText(i18n("The received fingerprint is:\n\n%1\n\nContact %2 via another secure channel and verify that this fingerprint is correct.").arg(OtrlChatInterface::self()->findActiveFingerprint(session)).arg(OtrlChatInterface::self()->formatContact(session->members().getFirst()->contactId())));
	alVerified->setText(i18n("verified that this is in fact the correct fingerprint for %1").arg(OtrlChatInterface::self()->formatContact(session->members().getFirst()->contactId())));
	cbVerify->insertItem(i18n("I have not"));
	cbVerify->insertItem(i18n("I have"));
	if( OtrlChatInterface::self()->isVerified(session)){
		cbVerify->setCurrentItem(1);
	} else {
		cbVerify->setCurrentItem(0);
	}
}

VerifyPopup::~VerifyPopup()
{
}

void VerifyPopup::cbChanged(){
	kdDebug() << "combobox changed" << endl;
	if( cbVerify->currentItem() == 0 ){
		OtrlChatInterface::self()->setTrust(session, false);
	} else {
		OtrlChatInterface::self()->setTrust(session, true);
	}
	OTRPlugin::plugin()->emitGoneSecure( session, OtrlChatInterface::self()->privState( session ) );
}

/*$SPECIALIZATION$*/


#include "verifypopup.moc"

