/***************************************************************************
 *   Copyright (C) 2007 by Michael Zanetti 
 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef OTRLCHATINTERFACE_H
#define OTRLCHATINTERFACE_H

/**
  * @author Michael Zanetti
  */

#include <tqstring.h>
#include <tqptrlist.h>
#include <tqvaluelist.h>
#include <tqthread.h>
#include <tqmutex.h>

#include <kopetechatsession.h>

extern "C" {
#include <libotr/privkey.h>
#include <libotr/proto.h>
#include <libotr/message.h>
#include <libotr/userstate.h>
}

class OtrlChatInterface: public TQObject
{

public:
	~OtrlChatInterface();
	static OtrlChatInterface *self();

	int decryptMessage( TQString *msg, TQString accountId, TQString protocol, TQString contactId, Kopete::ChatSession *chatSession );
	TQString encryptMessage( TQString msg, TQString accountId,
	TQString protocol, TQString contactId , Kopete::ChatSession *chatSession );
	TQString getDefaultQuery( TQString accountId );
	void disconnectSession( Kopete::ChatSession *chatSession );
	void setPolicy( OtrlPolicy policy );
	bool shouldDiscard( TQString message );
	OtrlUserState getUserstate();
	int privState( Kopete::ChatSession *session );
	TQString formatContact(TQString contactId);
	bool isVerified( Kopete::ChatSession *session );
	void updateKeyfile( Kopete::Account *account );
	void checkFilePermissions( TQString file );
//	bool verifyQuestion( Kopete::ChatSession *session, TQString fingerprint );
	TQString findActiveFingerprint( Kopete::ChatSession *session );
	void verifyFingerprint( Kopete::ChatSession *session );
	void abortSMP( ConnContext *context, Kopete::ChatSession *session );
	void respondSMP( ConnContext *context, Kopete::ChatSession *session, TQString secret, bool initiate );
	void setTrust( Kopete::ChatSession *session, bool trust );

private:
	OtrlChatInterface();
	static OtrlChatInterface *mSelf;
	Fingerprint *findFingerprint( TQString username );
};

 class KeyGenThread : public TQThread {

private:
	TQString accountname;
	TQString protocol;

public:
	KeyGenThread( TQString accountname, TQString protocol );
	virtual void run();
};

#endif
