/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
*/

/*
  Copyright (C) 2004 Peter Simonsson <psn@linux.se>
  Copyright (C) 2006-2008 Eike Hein <hein@kde.org>
*/

#ifndef KONVERSATIONSERVERLISTDIALOG_H
#define KONVERSATIONSERVERLISTDIALOG_H

#include "serverlistview.h"
#include "common.h"
#include "servergroupsettings.h"

#include <kdialogbase.h>

class ConnectionSettings;
class Preferences;
class TQPushButton;
class TQStringList;

namespace Konversation
{
    class ServerListItem : public KListViewItem
    {
        public:
            ServerListItem(KListView* parent, int serverGroupId, int sortIndex,
                const TQString& serverGroup, const TQString& identity, const TQString& channels);
            ServerListItem(TQListViewItem* parent, int serverGroupId, int sortIndex, 
                const TQString& name, const ServerSettings& server);

            int serverGroupId() const { return m_serverGroupId; }

            void setSortIndex(int id) { m_sortIndex = id; }
            int sortIndex() const { return m_sortIndex; }

            ServerSettings server() const { return m_server; }
            TQString name() const { return m_name; }
            bool isServer() const { return m_isServer; }

            int selectedChildrenCount();

            int compare(TQListViewItem *i, int col, bool ascending) const;

        private:
            int m_serverGroupId;
            int m_sortIndex;
            TQString m_name;
            ServerSettings m_server;
            bool m_isServer;
    };

    class ServerListDialog : public KDialogBase
    {
        Q_OBJECT
  TQ_OBJECT

        public:
            explicit ServerListDialog(TQWidget *parent = 0, const char *name = 0);
            ~ServerListDialog();

        public slots:
            void updateServerList();

        signals:
            void connectTo(Konversation::ConnectionFlag flag, int serverGroupId);
            void connectTo(Konversation::ConnectionFlag flag, ConnectionSettings& connectionSettings);
            void serverGroupsChanged(const Konversation::ServerGroupSettings* serverGroup = 0);

        protected slots:
            virtual void slotOk();
            void slotClose();
            void slotAdd();
            void slotEdit();
            void slotDelete();

            void slotSetGroupExpanded(TQListViewItem* item);
            void slotSetGroupCollapsed(TQListViewItem* item);

            void slotAboutToMove();
            void slotMoved();

            void updateButtons();

            void setShowAtStartup(bool show);

        protected:
            TQListViewItem* insertServerGroup(ServerGroupSettingsPtr serverGroup);
            void addServerGroup(ServerGroupSettingsPtr serverGroup);

        private:
            ServerListView* m_serverList;
            TQPushButton* m_addButton;
            TQPushButton* m_editButton;
            TQPushButton* m_delButton;

            bool m_selectedItem;
            int m_selectedServerGroupId;
            ServerSettings m_selectedServer;
            TQListViewItem* m_selectedItemPtr;

            int m_lastSortColumn;
            SortOrder m_lastSortOrder;
    };
}
#endif
