/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
*/

/*
  Copyright (C) 2002 Dario Abatianni <eisfuchs@tigress.com>
  Copyright (C) 2004 Peter Simonsson <psn@linux.se>
  Copyright (C) 2006-2008 Eike Hein <hein@kde.org>
*/

#ifndef INPUTFILTER_H
#define INPUTFILTER_H

#include "ignore.h"

#include <tqobject.h>
#include <tqstringlist.h>


class Server;
class TQWidget;
class Query;
class TQDateTime;

class InputFilter : public TQObject
{
    Q_OBJECT
  TQ_OBJECT

    public:
        InputFilter();
        ~InputFilter();

        void setServer(Server* newServer);
        void parseLine(const TQString &line);

        void reset();                             // reset AutomaticRequest, WhoRequestList

        // use this when the client does automatics, like userhost for finding hostmasks
        void setAutomaticRequest(const TQString& command, const TQString& name, bool yes);
        int getAutomaticRequest(const TQString& command, const TQString& name);
        void addWhoRequest(const TQString& name);  // called from Server::send()
                                                  // to avoid duplicate requests
        bool isWhoRequestUnderProcess(const TQString& name);
        void setLagMeasuring(bool yes);
        bool getLagMeasuring();

    signals:
        void welcome(const TQString& ownHost);
        void notifyResponse(const TQString &nicksOnline);
                                                  // will be connected to Server::startReverseDccSendTransfer()
        void startReverseDccSendTransfer(const TQString &sourceNick, const TQStringList &dccArgument);
                                                  // will be connected to Server::addDccGet()
        void addDccGet(const TQString &sourceNick, const TQStringList &dccArgument);
                                                  // will be connected to Server::resumeDccGetTransfer()
        void resumeDccGetTransfer(const TQString &sourceNick, const TQStringList &dccArgument);
                                                  // will be connected to Server::resumeDccSendTransfer()
        void resumeDccSendTransfer(const TQString &sourceNick, const TQStringList &dccArgument);
                                                  // will be connected to Server::userhost()
        void userhost(const TQString& nick,const TQString& hostmask,bool away,bool ircOp);
                                                  // will be connected to Server::setTopicAuthor()
        void topicAuthor(const TQString& channel, const TQString& author, TQDateTime t);
        void endOfWho(const TQString& target);     // for scheduling auto /WHO
        void addChannelListPanel();
        void addToChannelList(const TQString& channel,int users,const TQString& topic);
        void invitation(const TQString& nick,const TQString& channel);

        void addDccChat(const TQString& myNick,const TQString& nick,const TQStringList& arguments,bool listen);

    protected:
        void parseClientCommand(const TQString &prefix, const TQString &command, const TQStringList &parameterList, const TQString &trailing);
        void parseServerCommand(const TQString &prefix, const TQString &command, const TQStringList &parameterList, const TQString &trailing);
        void parseModes(const TQString &sourceNick, const TQStringList &parameterList);
        void parsePrivMsg(const TQString& prefix, const TQStringList& parameterList, const TQString& trailing);

        bool isAChannel(const TQString &check);
        bool isIgnore(const TQString &pattern, Ignore::Type type);

        Server* server;
                                                  // automaticRequest[command][channel or nick]=count
        TQMap< TQString, TQMap<TQString,int> > automaticRequest;
        TQStringList whoRequestList;
        int lagMeasuring;

        Query* query;

        int m_debugCount;

        /// Used when handling MOTD
        bool m_connecting;
};
#endif
