/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
*/

/*
  lets the user choose a nick from the list
  begin:     Sam Dez 7 2002
  copyright: (C) 2002 by Dario Abatianni
  email:     eisfuchs@tigress.com
*/

#include "dccrecipientdialog.h"

#include <tqlayout.h>

#include <klineedit.h>
#include <klocale.h>
#include <kdebug.h>


TQString DccRecipientDialog::selectedNickname;     // static

DccRecipientDialog::DccRecipientDialog(TQWidget* parent, const TQStringList &list,const TQSize &size) :
  KDialogBase(parent,"dcc_recipient_dialog",true,i18n("Select Recipient"),
	      KDialogBase::Ok | KDialogBase::Cancel,KDialogBase::Ok,true)
{
    // Create the top level widget
    TQWidget* page=new TQWidget(this);
    setMainWidget(page);
    // Add the layout to the widget
    TQVBoxLayout* dialogLayout=new TQVBoxLayout(page);
    dialogLayout->setSpacing(spacingHint());
    // Add the nickname list widget
    KListBox* nicknameList=new KListBox(page,"recipient_list");

    nicknameList->insertStringList(list);
    nicknameList->sort(true);

    nicknameInput=new KLineEdit(page,"nickname_input");

    dialogLayout->addWidget(nicknameList);
    dialogLayout->addWidget(nicknameInput);

    connect(nicknameList,TQT_SIGNAL (highlighted(TQListBoxItem*)),this,TQT_SLOT (newNicknameSelected(TQListBoxItem*)) );
    connect(nicknameList,TQT_SIGNAL (doubleClicked(TQListBoxItem*)),this,TQT_SLOT (newNicknameSelectedQuit(TQListBoxItem*)) );

    setButtonOK(KGuiItem(i18n("&OK"),"button_ok",i18n("Select nickname and close the window")));
    setButtonCancel(KGuiItem(i18n("&Cancel"),"button_cancel",i18n("Close the window without changes")));

    setInitialSize(size);
    show();
}

DccRecipientDialog::~DccRecipientDialog()
{
}

TQString DccRecipientDialog::getSelectedNickname()
{
    return selectedNickname;
}

void DccRecipientDialog::newNicknameSelected(TQListBoxItem* item)
{
    nicknameInput->setText(item->text());
}

void DccRecipientDialog::newNicknameSelectedQuit(TQListBoxItem* item)
{
    newNicknameSelected(item);
    selectedNickname=nicknameInput->text();

    delayedDestruct();
}

void DccRecipientDialog::slotCancel()
{
    selectedNickname=TQString();
    KDialogBase::slotCancel();
}

void DccRecipientDialog::slotOk()
{
    selectedNickname=nicknameInput->text();
    KDialogBase::slotOk();
}

TQString DccRecipientDialog::getNickname(TQWidget* parent, const TQStringList& list)
{
    TQSize size;                                   // TODO: get it from Preferences
    DccRecipientDialog dlg(parent,list,size);
    dlg.exec();

    return dlg.getSelectedNickname();
}

#include "dccrecipientdialog.moc"
