/*
  This program is free software; you can redistribute it and/or modifydvancedModes
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
*/

/*
  copyright: (C) 2004 by Peter Simonsson
  email:     psn@linux.se
*/
#ifndef KONVERSATIONCHANNELOPTIONSDIALOG_H
#define KONVERSATIONCHANNELOPTIONSDIALOG_H

#include "channel.h"

#include <tqstringlist.h>

#include <kdialogbase.h>
#include <klistview.h>


namespace Konversation
{
    class ChannelOptionsUI;

    class ChannelOptionsDialog : public KDialogBase
    {
        Q_OBJECT
  TQ_OBJECT
            public:
            explicit ChannelOptionsDialog(Channel *channel);
            ~ChannelOptionsDialog();

            TQString topic();
            TQStringList modes();


        public slots:
            void refreshTopicHistory();
            void refreshAllowedChannelModes();
            void refreshModes();
            void refreshEnableModes();
            void toggleAdvancedModes();

            void refreshBanList();
            void addBan(const TQString& newban);
            void addBanClicked();
            void removeBan(const TQString& ban);
            void removeBanClicked();
            void banEdited(TQListViewItem *edited);

            void changeOptions();


        protected slots:
            void topicHistoryItemClicked(TQListViewItem* item);
            void topicBeingEdited(bool state);

            void cancelClicked();
            void okClicked();


        protected:
            bool m_editingTopic;
            TQListViewItem *m_NewBan;


        private:
            ChannelOptionsUI* m_widget;
            Channel *m_channel;
    };


    // This is needed to overcome two deficiencies in KListViewItem
    // First there is no signal emitted when a rename is canceled
    // Second there is no way to get the old value of an item after a rename
    class BanListViewItem : public KListViewItem
    {
        public:
            explicit BanListViewItem( TQListView *parent );
            BanListViewItem(TQListView *parent, bool isNew);
            BanListViewItem(TQListView *parent, const TQString& label1, const TQString& label2 = TQString(), uint timestamp = 0);
            BanListViewItem (TQListView *parent, bool isNew, const TQString& label1, const TQString& label2 = TQString(), uint timestamp = 0);

            TQString getOldValue() { return m_oldValue; }
            TQDateTime timestamp() { return m_timestamp; }

            virtual TQString text(int column) const;
            virtual int compare(TQListViewItem *i, int col, bool ascending) const;
            virtual void startRename(int col);


        protected:
            virtual void cancelRename(int col);

            TQString m_oldValue;
            bool m_isNewBan;
            TQDateTime m_timestamp;
    };

}
#endif
