//KoHyphenator test, Lukas Tinkl <lukas.tinkl@suse.cz>

#include <stdio.h>
#include <stdlib.h>

#include <tqstringlist.h>

#include <kapplication.h>

#include "kohyphen.h"
#include <kdebug.h>

static bool check(TQString a, TQString b)
{
  if (a.isEmpty())
     a = TQString();
  if (b.isEmpty())
     b = TQString();
  if (a == b) {
    kdDebug() << "checking '" << a << "' against expected value '" << b << "'... " << "ok" << endl;
  }
  else {
    kdDebug() << "checking '" << a << "' against expected value '" << b << "'... " << "KO !" << endl;
    exit(1);
  }
  return true;
}

KoHyphenator * hypher = 0L;

void check_hyphenation( const TQStringList& tests, const TQStringList& results, const char* lang )
{
    TQStringList::ConstIterator it, itres;
    for ( it = tests.begin(), itres = results.begin(); it != tests.end() ; ++it, ++itres ) {
        TQString result = hypher->hyphenate((*it), lang);
        kdDebug() << (*it) << " hyphenates like this: " << result << endl;
        check( result.replace(TQChar(0xad),'-'), *itres );
    }
}

int main (int argc, char ** argv)
{
    KApplication app(argc, argv, "KoHyphenator test");

    try {
        hypher = KoHyphenator::self();
    }
    catch (KoHyphenatorException &e)
    {
        kdDebug() << e.message() << endl;
        return 1;
    }

    TQStringList::ConstIterator it, itres;

    //testing Czech language, this text is in UTF-8!
    TQStringList cs_tests = TQStringList() << "Žluťoučký" << "kůň" << "úpěl" <<
                        "ďábelské" << "ódy";

    for ( it = cs_tests.begin(); it != cs_tests.end() ; ++it )
        kdDebug() << (*it) << " hyphenates like this: " << hypher->hyphenate((*it), "cs") << endl;

    //testing English
    TQStringList en_tests = TQStringList() << "Follow" << "white" << "rabbit";
    TQStringList en_results = TQStringList() << "Fol-low" << "white" << "rab-bit";
    check_hyphenation( en_tests, en_results, "en" );

    TQStringList fr_tests = TQStringList() << "constitution" ;
    TQStringList fr_results = TQStringList() << "consti-tu-tion" ;
    check_hyphenation( fr_tests, fr_results, "fr" );

    return 0;
}
