/* This file is part of the KDE project
   Copyright (C)  2001,2002,2003 Montel Laurent <lmontel@mandrakesoft.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef __kofontdiapreview_h__
#define __kofontdiapreview_h__

#include <tqframe.h>
#include <tqstring.h>
#include <tqcolor.h>
#include <tqfont.h>
#include <tqpainter.h>

/**
 * The font dialog Preview
 */
class KoFontDiaPreview : public TQFrame
{
    Q_OBJECT
  TQ_OBJECT
public:
    /**
    * Constructor
    */
    KoFontDiaPreview( TQWidget* parent =0, const char* name = 0, WFlags fl = 0 );
    ~KoFontDiaPreview();

    void setText( const TQString &text );
    void setFont( const TQFont &font );
    void setFontColor( const TQColor &textColor );
    void setBackgroundColor( const TQColor &backgroundColor );
    void setShadow( double sdx, double sdy, TQColor shadowColor );
    void setUnderlining( int underlining, int underliningStyle, const TQColor underliningColor, bool wordByWord );
    void setWordByWord( bool wordByWord );
    void setStrikethrough( int strikethrough, int strikethroughStylestrikethrough, bool wordByWord );
    void setCapitalisation( int capitalisation );
    void setSubSuperscript( int subSuper, int offset, double relativeSize );


private:
    void drawContents( TQPainter* );

    TQString m_text;
    TQString displayText;
    TQFont m_font;
    TQFont displayFont;
    int m_fontSize;
    TQColor m_textColor;
    TQColor m_backgroundColor;
    double m_shadowDistanceX;
    double m_shadowDistanceY;
    TQColor m_shadowColor;
    int m_underlining;
    int m_underliningStyle;
    TQColor m_underliningColor;
    bool m_wordByWord;
    int m_strikethrough;
    int m_strikethroughStyle;
    int m_capitalisation;
    int m_subSuper;
    int m_offset;
    double m_relativeSize;

    TQString formatCapitalisation( const TQString &string );
    void drawUnderline( int x, int y, int width, int thickness, TQColor & color, TQPainter *p );
    void drawUnderlineWave( int x, int y, int width, int thickness, TQColor & color, TQPainter *p );
    void drawStrikethrough( int x, int y, int width, int thickness, TQPainter *p );
};

#endif
