/* This file is part of the KDE project
   Copyright (C)  2002 Montel Laurent <lmontel@mandrakesoft.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#include <klocale.h>
#include <tqvbox.h>
#include <tqmultilineedit.h>
#include "KoCommentDia.h"
#include <tqlayout.h>
#include <tqpushbutton.h>
#include <kglobal.h>
#include <tqdatetime.h>
#include <tqlabel.h>
#include <kdebug.h>

KoCommentDia::KoCommentDia( TQWidget *parent, const TQString &_note, const TQString & _authorName, const TQString &_createNote, const char *name )
    : KDialogBase( parent, name , true, "", Ok|Cancel, Ok, true )
{
    setCaption( i18n("Edit Comment") );
    authorName = _authorName;
    TQVBox *page = makeVBoxMainWidget();
    kdDebug()<<"_createNote :"<<_createNote<<endl;
    if ( !_createNote.isEmpty() )
        new TQLabel( _createNote, page );

    m_multiLine = new TQMultiLineEdit( page );
    m_multiLine->setText( _note );
    m_multiLine->setFocus();
    pbAddAuthorName = new TQPushButton(i18n("Add Author Name"),page);
    if ( authorName.isEmpty() )
        pbAddAuthorName->setEnabled( false );
    else
        connect (pbAddAuthorName, TQT_SIGNAL(clicked ()), this , TQT_SLOT(slotAddAuthorName()));
    connect ( m_multiLine , TQT_SIGNAL( textChanged()), this, TQT_SLOT( slotTextChanged(  )));
    slotTextChanged( );

    resize( 300,100 );
}

void KoCommentDia::slotTextChanged( )
{
    enableButtonOK( !m_multiLine->text().isEmpty() );
}

TQString KoCommentDia::commentText()
{
    return m_multiLine->text();
}

void KoCommentDia::slotAddAuthorName()
{
    TQString date = KGlobal::locale()->formatDate( TQDate::currentDate() );
    TQString time = KGlobal::locale()->formatTime( TQTime::currentTime() );
    TQString result = TQString("--------%1 ,%2, %3------\n").arg(authorName).arg(date).arg(time);
    m_multiLine->insertLine( result, m_multiLine->numLines() );
}

#include "KoCommentDia.moc"
