/* This file is part of the KDE project
   Copyright (C) 2004 Cedric Pasteur <cedric.pasteur@free.fr>
   Copyright (C) 2004  Alexander Dymo <cloudtemple@mskat.net>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#include <tqlineedit.h>
#include <tqpushbutton.h>
#include <tqlayout.h>
#include <tqpainter.h>
#include <tqvariant.h>

#include <kcharselect.h>
#include <klocale.h>
#include <kdialogbase.h>

#include "symbolcombo.h"

using namespace KoProperty;

SymbolCombo::SymbolCombo(Property *property, TQWidget *parent, const char *name)
 : Widget(property, parent, name)
{
	setHasBorders(false);
	TQHBoxLayout *l = new TQHBoxLayout(this);

	m_edit = new TQLineEdit(this);
	m_edit->setLineWidth(0);
	m_edit->setReadOnly(true);
	m_edit->setSizePolicy(TQSizePolicy::Expanding, TQSizePolicy::Expanding);
	m_edit->setMinimumHeight(5);
	m_edit->setMaxLength(1);
	l->addWidget(m_edit);
	m_select = new TQPushButton("...", this);
	m_select->setSizePolicy(TQSizePolicy::Maximum, TQSizePolicy::MinimumExpanding);
	m_select->setMinimumHeight(5);
	l->addWidget(m_select);

	connect(m_select, TQT_SIGNAL(clicked()), this, TQT_SLOT(selectChar()));
	connect(m_edit, TQT_SIGNAL(textChanged(const TQString&)), this, TQT_SLOT(slotValueChanged(const TQString&)));
}

SymbolCombo::~SymbolCombo()
{}

TQVariant
SymbolCombo::value() const
{
	if (!(m_edit->text().isNull()))
		return m_edit->text().at(0).unicode();
	else
		return 0;
}

void
SymbolCombo::setValue(const TQVariant &value, bool emitChange)
{
	if (!(value.isNull()))
	{
		m_edit->blockSignals(true);
		m_edit->setText(TQChar(value.toInt()));
		m_edit->blockSignals(false);
		if (emitChange)
			emit valueChanged(this);
	}
}

void
SymbolCombo::drawViewer(TQPainter *p, const TQColorGroup &cg, const TQRect &r, const TQVariant &value)
{
//	p->eraseRect(r);
//	p->drawText(r, TQt::AlignLeft | TQt::AlignVCenter | TQt::SingleLine, TQChar(value.toInt()));
	Widget::drawViewer(p, cg, r, TQString( TQChar(value.toInt()) ));
}

void
SymbolCombo::selectChar()
{
	KDialogBase dialog(this->topLevelWidget(), "charselect_dialog", true, i18n("Select Char"),
	    KDialogBase::Ok|KDialogBase::Cancel, KDialogBase::Ok, false);

	KCharSelect *select = new KCharSelect(&dialog, "select_char");
	dialog.setMainWidget(select);

	if (!(m_edit->text().isNull()))
		select->setChar(m_edit->text().at(0));

	if (dialog.exec() == TQDialog::Accepted)
		m_edit->setText(select->chr());
}

void
SymbolCombo::slotValueChanged(const TQString&)
{
	emit valueChanged(this);
}

void
SymbolCombo::setReadOnlyInternal(bool readOnly)
{
	m_select->setEnabled(!readOnly);
}

#include "symbolcombo.moc"
