/* This file is part of the KDE project
  Copyright (c) 1999 Matthias Elter (me@kde.org)

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef __ko_ColorSlider_h__
#define __ko_ColorSlider_h__

#include <tqframe.h>
#include <tqpoint.h>
#include <tqimage.h>
#include <tqwidget.h>
#include <kpixmap.h>
#include <koffice_export.h>
class SliderWidget;

class KOPAINTER_EXPORT KoColorFrame : public TQFrame
{
  Q_OBJECT
  TQ_OBJECT
public:
  KoColorFrame(TQWidget *parent = 0L);

  const TQColor colorAt(const TQPoint &p);
  
protected:
  void drawContents(TQPainter *p);
  void mousePressEvent(TQMouseEvent *e);
  void mouseMoveEvent(TQMouseEvent *e);
  void mouseReleaseEvent(TQMouseEvent *e);
  
public slots:
  void slotSetColor1(const TQColor &c);
  void slotSetColor2(const TQColor &c);

signals:
  void clicked(const TQPoint &p);
  void colorSelected(const TQColor &c);

protected:
  TQColor mC1;
  TQColor mC2;
  KPixmap mPixmap;
  TQImage  mImage;
  bool mColorChanged;
  bool mPixChanged;
  bool mDragging;
};

class KOPAINTER_EXPORT KoSliderWidget : public TQWidget
{
  Q_OBJECT
  TQ_OBJECT
public:
  KoSliderWidget(TQWidget *parent = 0L);

protected:
  void mousePressEvent(TQMouseEvent *e);
  void mouseReleaseEvent(TQMouseEvent *e);
  void mouseMoveEvent(TQMouseEvent *e);
  void paintEvent(TQPaintEvent *);
  
signals:
  void positionChanged(int);

protected:
  bool mDragging;
  TQPoint mPos;
};

class KOPAINTER_EXPORT KoColorSlider : public TQWidget
{
  Q_OBJECT
  TQ_OBJECT
public:
  KoColorSlider(TQWidget *parent = 0L);
  virtual ~KoColorSlider();

  int minValue();
  int maxValue();

protected:
  void resizeEvent(TQResizeEvent *);
  void mousePressEvent(TQMouseEvent *);
  
public slots:
  void slotSetColor1(const TQColor &c);
  void slotSetColor2(const TQColor &c);

  void slotSetValue(int value);
  void slotSetRange(int min, int max);

protected slots:
  void slotSliderMoved(int x);
  void slotFrameClicked(const TQPoint &p);

signals:
  void colorSelected(const TQColor &c);
  void valueChanged(int value);

protected:
  KoSliderWidget *mSlider;
  KoColorFrame *mColorFrame;
  int mMin, mMax;
  int mValue;
};

#endif
