/* This file is part of the KDE project
   Copyright (C) 1999 by Dirk A. Mueller <dmuell@gmx.net>
   Copyright (C) 2002 Werner Trobin <trobin@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#include <tqlayout.h>
#include <tqvgroupbox.h>
#include <tqpopupmenu.h>
#include <tqmenubar.h>

#include <kdebug.h>
#include <ktoolbar.h>
#include <kiconloader.h>
#include <kapplication.h>
#include <KoTooluButton.h>
#include <coloraction_test.h>

#include <stdlib.h>
#include <time.h>


TopLevel::TopLevel( TQWidget* parent, const char* name) : TQMainWindow( parent, name )
{
    setCaption( TQString::fromLatin1( "KColorAction test application" ) );

    TQWidget *w = new TQWidget( this );
    setCentralWidget( w );

    TQBoxLayout* l = new TQHBoxLayout( w, KDialog::marginHint(), KDialog::spacingHint() );
    TQGroupBox* b1 = new TQVGroupBox( TQString::fromLatin1( "KoColorPanel 1" ), w );
    panel = new KoColorPanel( b1, "panel1" );
    connect( panel, TQT_SIGNAL( colorSelected( const TQColor& ) ), TQT_SLOT( slotColorSelected( const TQColor& ) ) );
    //panel->insertDefaultColors();
    l->addWidget( b1 );

    b1 = new TQVGroupBox( TQString::fromLatin1( "KoColorPanel 2" ), w );

    ( void ) new KoColorPanel( b1, "panel2" );
    l->addWidget( b1 );

    TQPopupMenu* file = new TQPopupMenu( this );
    menuBar()->insertItem( "&File", file );

    file->insertItem( "Custom + Default", KoColorPanel::createColorPopup( KoColorPanel::CustomColors, TQt::red, this,
                                                                          TQT_SLOT( slotColorSelected( const TQColor& ) ), file, "blah" ) );
    file->insertItem( "Custom", KoColorPanel::createColorPopup( KoColorPanel::CustomColors, TQColor(), this,
                                                                TQT_SLOT( slotColorSelected( const TQColor& ) ), file, "blah" ) );
    file->insertItem( "Plain + Default", KoColorPanel::createColorPopup( KoColorPanel::Plain, TQt::green, this,
                                                                         TQT_SLOT( slotColorSelected( const TQColor& ) ), file, "blah" ) );
    file->insertItem( "Plain", KoColorPanel::createColorPopup( KoColorPanel::Plain, TQColor(), this,
                                                               TQT_SLOT( slotColorSelected( const TQColor& ) ), file, "blah" ) );
    file->insertSeparator();
    file->insertItem( "Default Colors", this, TQT_SLOT( defaultColors() ), CTRL+Key_D );
    file->insertItem( "Insert Random Color", this, TQT_SLOT( insertRandomColor() ), CTRL+Key_R );
    file->insertSeparator();
    file->insertItem( "Clear", this, TQT_SLOT( clearColors() ), CTRL+Key_C );
    file->insertSeparator();
    file->insertItem( "&Quit", tqApp, TQT_SLOT( closeAllWindows() ), CTRL+Key_Q );

    KToolBar* toolBar = new KToolBar( this );
    addDockWindow( toolBar );
    ( void ) new KoToolButton( "color_fill", 1, toolBar, "funky button", "Fill Color" );
}

void TopLevel::insertRandomColor()
{
    panel->insertColor( tqRgb( rand() % 256, rand() % 256, rand() % 256 ) );
}

void TopLevel::defaultColors()
{
    panel->insertDefaultColors();
}

void TopLevel::clearColors()
{
    panel->clear();
}

void TopLevel::slotColorSelected( const TQColor& color )
{
    kdDebug() << "#### selected: " << color.name() << endl;
}


int main( int argc, char ** argv )
{
    srand( time( 0 ) );

    KApplication a( argc, argv, "KColorAction Test" );
    TopLevel *toplevel = new TopLevel( 0, "coloractiontest" );
    a.setMainWidget( toplevel );
    toplevel->show();
    return a.exec();
}

#include <coloraction_test.moc>
