/* This file is part of the KDE project
   Copyright (C) 2001 Andrea Rizzi <rizzi@kde.org>
	              Ulrich Kuettler <ulrich.kuettler@mailbox.tu-dresden.de>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef KFORMULAWIDGET_H
#define KFORMULAWIDGET_H

#include <tqdom.h>
#include <tqpixmap.h>
#include <tqpoint.h>
#include <tqwidget.h>

#include "kformuladefs.h"
#include "kformulaview.h"

KFORMULA_NAMESPACE_BEGIN

class BasicElement;
class FormulaCursor;
class FormulaElement;
class Container;

KFORMULA_NAMESPACE_END

using namespace KFormula;


/**
 * The view. A widget that shows the formula. There are methods
 * to move the cursor around. To edit the formula use the document.
 */
class KFormulaWidget : public TQWidget {
    Q_OBJECT
  TQ_OBJECT

public:
    KFormulaWidget(Container*, TQWidget* parent=0, const char* name=0, WFlags f=0);
    ~KFormulaWidget();


    /**
     * @returns the point inside the formula widget where the cursor is.
     */
    TQPoint getCursorPoint() const;

    /**
     * Puts the widget in read only mode.
     */
    void setReadOnly(bool ro);

public slots:

    void slotSelectAll();

signals:

    /**
     * Is emitted every time the cursor might have changed.
     */
    void cursorChanged(bool visible, bool selecting);

protected slots:

    /**
     * The formula has changed and needs to be redrawn.
     */
    void slotFormulaChanged(int width, int height);

    void slotCursorChanged(bool visible, bool selecting);

protected:

    virtual void mousePressEvent(TQMouseEvent* event);
    virtual void mouseReleaseEvent(TQMouseEvent* event);
    virtual void mouseDoubleClickEvent(TQMouseEvent* event);
    virtual void mouseMoveEvent(TQMouseEvent* event);
    virtual void wheelEvent(TQWheelEvent* event);

    virtual void paintEvent(TQPaintEvent* event);
    virtual void keyPressEvent(TQKeyEvent* event);
    virtual void focusInEvent(TQFocusEvent* event);
    virtual void focusOutEvent(TQFocusEvent* event);

    /**
     * The document we show.
     */
    Container* getDocument();

    /**
     * Our cursor.
     */
    FormulaCursor* getCursor();

private:

    /**
     * This widget is a wrapper around the actual view.
     */
    View formulaView;

    TQPixmap buffer;
};

#endif // KFORMULAWIDGET_H
